var slugify = require('slugify')
const roomModel = require('../model/rooms');
const hotelModel = require('../model/hotel');
const mediaModel = require('../model/rooms_images');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");
const XLSX = require('xlsx');

// var moment = require('moment'); // require
var moment = require('moment-timezone');
var newYork    = moment.tz("2014-06-01 23:59", "America/New_York");

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')

/// Create and Save a new Room Details
exports.create = async (req, res) => {
    console.log("Room Body data", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Room Title." });
    }
    if (!req.body.hotel_id) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Hotel Name." });
    }
    if (!req.body.priceList) {
        return res.status(400).send({ "is_error": true, "message": "Please Provide Room Price" });
    }
    if (req.body.priceList && req.body.priceList.length == 0) {
        return res.status(400).send({ "is_error": true, "message": "Please Provide Room Price" });
    }

    // process PriceList Data for Datetime modifications to Newyork TimeZone
    let prices = req.body.priceList ? JSON.parse(req.body.priceList) : [];
    const roomsPriceList = await prices.map(item=>{
        item.startDate = moment(item.startDate).set("hour", 0).set("minute", 0).utc().tz("America/New_York");
        item.endDate =   moment(item.endDate).set("hour", 23).set("minute", 59).utc().tz("America/New_York");
        return item ;
    });

    console.log("final PriceList", roomsPriceList);
    // Create a Room Payload
    const roomPayload = new roomModel({
        name: req.body.name,
        hotel_id: req.body.hotel_id,
        priceList: roomsPriceList,
        description: req.body.description,
        terms_conditions: req.body.terms_conditions,
        // facilities: [],
        cat_code: (req.body.cat_code).toUpperCase(),
        room_cat_group: req.body.room_cat_group,
        room_subcat_group: req.body.room_subcat_group,
        love_nest: req.body.love_nest,
        on_request_booking: req.body.on_request_booking,
        slug: slugify((req.body.name).toLowerCase()),
        externalVideoList: req.body.externalVideoList ? JSON.parse(req.body.externalVideoList) : [],
        roomFacilities: req.body.roomFacilities ? JSON.parse(req.body.roomFacilities) : [],
        highlightedFacilities: req.body.highlightedFacilities ? JSON.parse(req.body.highlightedFacilities) : [],
        roomView: req.body.roomView ? JSON.parse(req.body.roomView) : [],
        discount_percent: req.body.discount_percent,
        ctn_markup_percent: req.body.ctn_markup_percent,
        agent_markdown_percent: req.body.agent_markdown_percent,
        bed_type: {
            'single':req.body.single_bed_count,
            'twins':req.body.twins_bed_count,
            'double': req.body.double_bed_count,
            'king': req.body.kingSize_bed_count,
            'queen': req.body.queenSize_bed_count,
            'sofa':req.body.sofa_bed_count,
        }
    });

    // Save Room in the database
    roomPayload.save()
        .then(async data => {
            let media = [];
            const mediaRootPath = "public/uploads/rooms/";
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const roomMediaFiles = req.files[key];
                    await roomMediaFiles.forEach(async mediaFile => {
                        media.push({
                            path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                            filename: mediaFile.filename,
                            ref_id: data._id,
                            type: mediaFile.fieldname,
                            mimetype: mediaFile.mimetype,
                            description: '',
                            extn: (mediaFile.filename.split('.').pop()).toLowerCase()
                        });
                    })

                } else {
                    console.log("Else condition block")
                }
            })
            if(!data) {
                // remove all recently uploaded images from directory
                media.forEach(element => {
                    mediaUtils.unlink(element.path);
                });
                return res.status(404).send({
                    is_error : true,
                    message: "Error while creating Room."
                });
            }
            console.log("media object", media)
            // store all room images and videos
            await mediaModel.insertMany(media);
    
            res.send({ is_error: false, data: data });

        }).catch(err => {
            // delete all uploaded room iamges files from directory
            const mediaRootPath = "public/uploads/rooms/";
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const roomMediaFiles = req.files[key];
                    await roomMediaFiles.forEach(async mediaFile => {
                        // call util method to remove file from location
                        mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                    })
                }
            })
            return res.status(500).send({
                is_error: true,
                message: err.message || "Some error occurred while creating the Room."
            });
        });
};

// Retrieve and return all room from the database.
exports.findAll = async (req, res) => {
    // roomModel.updateMany({}, {'discount_percent':40,'ctn_markup_percent':20,'agent_markdown_percent':10} , {new: true})
    // .then(async response => {
    //     console.log("Success", response)
    // })

    try {
        console.log("req.query", req.query)
        var query = (req.query && req.query.hotel_id) ? req.query : {}
        const rooms = await roomModel.find(query)
            .populate({ path: 'hotel_id', select: ["name"] })
            .populate({ path: 'room_cat_group', select: ["group_name"] })
            .populate({ path: 'room_subcat_group', select: ["group_name"] })
            .populate({ path: 'mainPhoto'})
            .populate({ path: 'BannerPhoto'})
            .sort([["updatedAt", -1]]);
        res.send({ is_error: false, data: rooms });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a single Room Details with room id
exports.findOne = (req, res) => {
    roomModel.findById(req.params.id)
        .then(async response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found with id " + req.params.id
                });
            }
            const projectMedia = await mediaModel.find({ref_id: req.params.id});
            console.log("projectMedia", projectMedia);
            response.mediaFiles = projectMedia ;
            res.send({is_error : false, data: response, mediaFiles: projectMedia });
            // res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details with id " + req.params.id
            });
        });
};

// Find a single Room with a slug
exports.findRoomBySlug = async (req, res) => {
    roomModel.findOne({ 'slug': req.params.slug })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for " + req.params.slug
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for  " + req.params.slug
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details for  " + req.params.slug
            });
        });
};

exports.findRoomAdminDetailsPageData = async (req, res) => {
    roomModel.findById(req.params.id)
        .populate({ path: 'hotel_id', select: ["name","countryMetaData","city","rating","slug"] })
        .populate({ path: 'room_cat_group', select: ["group_name"] })
        .populate({ path: 'room_subcat_group', select: ["group_name"] })
        .populate({ path: 'mainPhoto'})
        .populate({ path: 'BannerPhoto'})
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            console.log(err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for  " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details for  " + req.params.id
            });
        });
};

// Update Room details
exports.update = async (req, res) => {

    console.log("req.body", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Room Category." });
    }
    if (!req.body.hotel_id) {
        return res.status(400).send({ "is_error": true, "message": "Please select Hotel." });
    }
    if (!req.body.priceList) {
        return res.status(400).send({ "is_error": true, "message": "Please Provide Room Price" });
    }
    if (req.body.priceList && req.body.priceList.length == 0) {
        return res.status(400).send({ "is_error": true, "message": "Please Provide Room Price" });
    }
    // process PriceList Data for Datetime modifications to Newyork TimeZone
    let prices = req.body.priceList ? JSON.parse(req.body.priceList) : [];
    const roomsPriceList = await prices.map(item=>{
        item.startDate = moment(item.startDate).set("hour", 0).set("minute", 0).utc().tz("America/New_York");
        item.endDate =   moment(item.endDate).set("hour", 23).set("minute", 59).utc().tz("America/New_York");
        return item ;
    });

    console.log("final PriceList", roomsPriceList);
    // Create a Room Payload
    const roomPayload = {
        name: req.body.name,
        hotel_id: req.body.hotel_id,
        priceList: roomsPriceList,
        description: req.body.description,
        terms_conditions: req.body.terms_conditions,
        // facilities: [],
        cat_code: (req.body.cat_code).toUpperCase(),
        room_cat_group: req.body.room_cat_group,
        room_subcat_group: req.body.room_subcat_group,
        love_nest: req.body.love_nest,
        on_request_booking: req.body.on_request_booking,
        slug: slugify((req.body.name).toLowerCase()),
        externalVideoList: req.body.externalVideoList ? JSON.parse(req.body.externalVideoList) : [],
        roomFacilities: req.body.roomFacilities ? JSON.parse(req.body.roomFacilities) : [],
        highlightedFacilities: req.body.highlightedFacilities ? JSON.parse(req.body.highlightedFacilities) : [],
        roomView: req.body.roomView ? JSON.parse(req.body.roomView) : [],
        discount_percent: req.body.discount_percent,
        ctn_markup_percent: req.body.ctn_markup_percent,
        agent_markdown_percent: req.body.agent_markdown_percent,
        bed_types: {
            'single':req.body.single_bed_count,
            'twins':req.body.twins_bed_count,
            'double': req.body.double_bed_count,
            'king': req.body.kingSize_bed_count,
            'queen': req.body.queenSize_bed_count,
            'sofa':req.body.sofa_bed_count,
        }
    };

    console.log("final Payload Data", roomPayload)

    // return res.send("hola");

    // Find room and update it with the request body
    roomModel.findByIdAndUpdate(req.params.id, roomPayload, { new: true })
        .then(async response => {
            let media = [];
            const mediaRootPath = "public/uploads/rooms/";
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const projectMediaFiles = req.files[key];
                    await projectMediaFiles.forEach(async mediaFile => {
                        media.push({
                            path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                            filename: mediaFile.filename,
                            ref_id: response._id,
                            type: mediaFile.fieldname,
                            mimetype: mediaFile.mimetype,
                            extn: (mediaFile.filename.split('.').pop()).toLowerCase()
                        });
                    })

                } else {
                    console.log("Else condition block")
                }
            })
             
            if (!response) {
                // remove all recently uploaded images from directory
                media.forEach(element => {
                    mediaUtils.unlink(element.path);
                });
                return res.status(404).send({
                    is_error: true,
                    message: "Room not found with id " + req.params.id
                });
            }
            // store all images,documents and videos
            await mediaModel.insertMany(media);
            // Remove all the removed media from directory and Media Collection
            if (req.body.existingFilesData) {
                const filesTobeRemoved = JSON.parse(req.body.existingFilesData);
                await filesTobeRemoved.forEach(element => {
                    if(element.deleted){
                        mediaUtils.unlink(element.path);
                        // delete record from Media collection
                        mediaModel.findByIdAndUpdate(element._id,element).exec();
                    }else{
                        // only update the records with updated data of description
                        mediaModel.findByIdAndUpdate(element._id,element).exec();
                    }
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            // delete all uploaded Hotel media files from directory
            const mediaRootPath = "public/uploads/rooms/";
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const projectMediaFiles = req.files[key];
                    await projectMediaFiles.forEach(async mediaFile => {
                        // call util method to remove file from location
                        mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                    })
                }
            })
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Room with id " + err
            });
        });
};

// Delete a Room with the specified id in the request
exports.delete = (req, res) => {
    roomModel.findByIdAndRemove(req.params.id)
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, message: "Room deleted successfully!" });
        }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Could not delete Room with id " + req.params.id
            });
        });
};

// Change Room  status
exports.changeStatus = async (req, res) => {
    console.log("room Id", req.params.id)

     // check the Hotel status , If active then only allow room to mark Active  when req.body data is coming true.
     if(req.body.is_active){
        const RoomDetails = await roomModel.findById(req.params.id);
        if(RoomDetails){
            const hotelStatus = await hotelModel.findOne({_id: RoomDetails.hotel_id});
            if(!hotelStatus.is_active){
                return res.status(404).send({
                    is_error: true,
                    message: "Room status cannot be marked as Opened , Hotel Sale is STOPPED currently."
                });
            }
    
        }else{
            return res.status(404).send({
                is_error: true,
                message: "Invalid Room Details."
            }); 
        }
    }
    await roomModel.findByIdAndUpdate(req.params.id, {
        is_available: req.body.is_available
    }, { timestamps: false })
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Room Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Available' : 'Unavailable';
            res.send({ 'message': 'Room has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the Room status."
            });
        });
};

// get room images
exports.getRoomImages = async (req, res) => {
    const roomImagesdata = await mediaModel.find({ref_id: req.params.roomId ,deleted: false });
    res.send({ is_error: false, data: roomImagesdata });
};

exports.dumpRoomData = async (req,res) => {

    // console.log("selected file", fileName)
    var workbook = XLSX.readFile('./public/assets/mockData/rooms/rooms-SMB.xlsx');
    var sheet_name_list = workbook.SheetNames;
    console.log("no. of sheets", sheet_name_list);
    // console.log(XLSX.utils.sheet_to_json(workbook.Sheets[sheet_name_list[0]]))
    const parsedData = XLSX.utils.sheet_to_json(workbook.Sheets[sheet_name_list[0]]) ;
    
    // res.send(parsedData)

    parsedData.forEach(async item=>{
        const payload = {
            name: item.name,
            hotel_id: '643bc7a159c21520ee7ccc02',
            cat_code: item.cat_code ? (item.cat_code).toUpperCase() : '',
            room_cat_group: item.room_cat_group ? item.room_cat_group : '',
            love_nest: item.love_nest ? true : false,
            on_request_booking: (item.name).includes("^") ? true : false,
            slug: slugify((item.name).toLowerCase()),
            
            // priceList: JSON.parse(item.priceList),
            // description: item.description,
            // terms_conditions: item.terms_conditions,
            // facilities: [],
        };
        console.log("final Payload", payload)
        const dataRecord = new roomModel(payload);
        // Save record in the database
        await dataRecord.save();
    })

    res.send(parsedData)

};

exports.dumpRoomPrices = async (req,res) => {

    // console.log("selected file", fileName)
    var workbook = XLSX.readFile('./public/assets/mockData/rooms/SMB-roomsWprices-2023.xlsx');
    var sheet_name_list = workbook.SheetNames;
    console.log("no. of sheets", sheet_name_list);
    // console.log(XLSX.utils.sheet_to_json(workbook.Sheets[sheet_name_list[0]]))
    const parsedData = XLSX.utils.sheet_to_json(workbook.Sheets[sheet_name_list[0]]) ;
    
//   var parsedData = [];

        // var worksheet = workbook.Sheets[sheet_name_list[0]];
        // var headers = {};
        // var data = [];
        // var headersArr = [];
        // var abc = {
        //     priceList: []
        // };
        // var fullDBArrData = [];

        // // console.log("worksheet",worksheet);
        // for(z in worksheet) {
        //     if(z[0] === '!') continue;
        //     //parse out the column, row, and value
        //     var col = z.substring(0,1);
        //     var row = parseInt(z.substring(1));
        //     var value = worksheet[z].v;
        //     //store header names
        //     if(row == 1) {
        //         headers[col] = value;
        //         continue;
        //     }
        //     if(headers[col] != 'name' && headers[col] != 'cat_code' && headers[col] != 'room_cat_group' && headers[col] != 'love_nest'){
        //         headersArr.push(value);
        //         var dateValue = headers[col].split('~');
        //         // var startDate = moment(dateValue[0], "DD-MM-YYYY", true).toDate()
        //         // var endDate = moment(dateValue[1], "DD-MM-YYYY", true).toDate()
        //         var startDate = moment(dateValue[0]).set("hour", 0).set("minute", 0).toISOString();
        //         var endDate = moment(dateValue[1]).set("hour", 23).set("minute", 59).toISOString();
        //         // console.log(dateValue[0])
        //         // console.log("dateValue", moment('15-06-2010', 'YYYY-MM-DD'))
        //         // console.log("Is valid date",startDate.isValid())

        //         roomDetailObj = {
        //             startDate: startDate,
        //             enddateDate: endDate,
        //             price: value,
        //         }
        //         // console.log("priceObj", roomDetailObj)
        //         abc.priceList.push(roomDetailObj);
        //     }

        //     if(!data[row]) data[row]={};
        //     data[row][headers[col]] = value;
        //     fullDBArrData.push(abc);
        // }
        // // console.log("headers array", headersArr)
        // //drop those first two rows which are empty
        // data.shift();
        // data.shift();
        // console.log("fullDBArrData",JSON.stringify(fullDBArrData));
        // console.log("fullDBArrData",fullDBArrData);
        // parsedData = fullDBArrData ;


    // parsedData.forEach(async item=>{
    //     const payload = {
    //         name: item.name,
    //         hotel_id: '643bc7a159c21520ee7ccc02',
    //         cat_code: item.cat_code ? (item.cat_code).toUpperCase() : '',
    //         room_cat_group: item.room_cat_group ? item.room_cat_group : '',
    //         love_nest: item.love_nest ? true : false,
    //         on_request_booking: (item.name).includes("^") ? true : false,
    //         slug: slugify((item.name).toLowerCase()),
    //         priceList: item.priceList,

    //         // description: item.description,
    //         // terms_conditions: item.terms_conditions,
    //         // facilities: [],
    //     };
    //     // console.log("final Payload", payload)
    //     const dataRecord = new roomModel(payload);
    //     // Save record in the database
    //     await dataRecord.save();
    // })

    parsedData.forEach(async item => {
        let payload = {
            name: item.name,
            hotel_id: '643bc7a159c21520ee7ccc02',
            cat_code: item.cat_code ? (item.cat_code).toUpperCase() : '',
            room_cat_group: item.room_cat_group ,
            love_nest: item.love_nest ? true : false,
            on_request_booking: (item.name).includes("^") ? true : false,
            slug: slugify((item.name).toLowerCase()),
            priceList:[]
        }
        if(item.room_subcat_group && item.room_subcat_group !=''){
            payload['room_subcat_group'] = item.room_subcat_group
        }
        dataKeys = Object.keys(item);
        // console.log("keys", dataKeys)
        dataKeys.forEach((KeyItem)=> {
            if(KeyItem != 'name' && KeyItem != 'cat_code' && KeyItem != 'room_cat_group' && KeyItem != 'room_subcat_group' && KeyItem != 'love_nest' && KeyItem != 'on_request_booking' && KeyItem != 'category' && KeyItem != 'subcategory'){
              
                var dateValue = KeyItem.split('~');
                // var startDate = moment(moment(dateValue[0], "DD-MM-YYYY", true).toDate()).toISOString();
                // var endDate = moment(moment(dateValue[1], "DD-MM-YYYY", true).toDate()).set("hour", 23).set("minute", 59).toISOString();
                const startTime = moment(dateValue[0], "DD-MM-YYYY", true).set("hour", 0).set("minute", 0).utc().tz("America/New_York");
                const endTime = moment(dateValue[1], "DD-MM-YYYY", true).set("hour", 23).set("minute", 59).utc().tz("America/New_York");
                console.log("parsed End time", endTime)
                // var startDate = moment(dateValue[0]).set("hour", 0).set("minute", 0).toISOString();
                // var endDate = moment(dateValue[1]).set("hour", 23).set("minute", 59).toISOString();
                
                var priceDataObj = {
                    'startDate':startTime,
                    'endDate':endTime,
                    'price': parseFloat(item[KeyItem]),
                    'year': moment(endTime).year()
                }
                console.log("priceObj", priceDataObj)
                payload.priceList.push(priceDataObj)                
            }
        })
        console.log("payload", payload)
        const dataRecord = new roomModel(payload);
        // Save record in the database
        await dataRecord.save();

    })
    console.log("Parsed daat length", parsedData.length)
    res.send({'parsedData': parsedData , 'total':parsedData.length})

};