const bookingModel = require('../model/bookings');

// Retrieve and return all Bookings from the database.
exports.findAll = async (req, res) => {
    try {
        const transactionsData = await bookingModel.find({})
        .populate({ path: 'hotel_id', select: ["name","countryMetaData","city","rating","slug"] })
        .populate({path:'room_id',select:["name"]})
        .populate({path:'transaction_id',select:["transaction_id","payment_method","payment_status"]})
        .sort([["updatedAt",-1]]);
        res.send({is_error : false, data: transactionsData});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single Booking Details with a id
exports.findOne = (req, res) => {
 bookingModel.findById(req.params.id)
    .populate({ path: 'hotel_id', select: ["name","countryMetaData","city","rating","slug"] })
    .populate({ path:'room_id' })
    .populate({ path:'transaction_id' })
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Booking Details not found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Booking Details not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving Booking Details with id " + req.params.id
        });
    });
};

// Retrieve and return all latest Bookings from the database.
exports.findBookingsForAdminDashboard = async (req, res) => {
    try {
        const transactionsData = await bookingModel.find({})
        .populate({ path: 'hotel_id', select: ["name","countryMetaData","city","rating","slug"] })
        .populate({path:'room_id',select:["name"]})
        .populate({path:'transaction_id',select:["transaction_id","payment_method","payment_status"]})
        .limit(10)
        .sort([["updatedAt",-1]]);
        res.send({is_error : false, data: transactionsData});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };