var slugify = require('slugify')
const catModel = require('../model/category');
const helper = require('../middleware/_helper');
// addNewCategory
exports.addCategory = async (req, res) => {
    console.log("Category Body data", req.body)
    // Validate request
    if (!(req.body.name)) {
        return res.status(400).send({ "is_error": true, "message": "All input is required" });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // check if category already exist
        // Validate if category exist in our database
        const oldCat = await catModel.findOne({ 'name': req.body.name ,'created_by': loggedInUser.data.user_id, 'parent': null });

        if (oldCat) {
        return res.status(409).send({"is_error": true , "message":  req.body.name + " Category Already Exist" });
        }
        // Create a category
        const catData = new catModel({
            name: req.body.name,
            created_by: loggedInUser.data.user_id,
            slug: slugify((req.body.name).toLowerCase())
        });

        // Save Category in the database
        catData.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
               return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while creating the category."
                });
            });
    }
};

// Get all DB categories
exports.getAllCategories = async (req, res) => {
    try {
        const categoryData = await catModel.find({ parent: { $eq: null } }).sort([["updatedAt",-1]]);
        res.send({ is_error: false, data: categoryData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Get all DB Sub categories
exports.getAllSubCategories = async (req, res) => {
    try {
        const categoryData = await catModel.find({ parent: { $ne: null } }).sort([["updatedAt",-1]]);
        res.send({ is_error: false, data: categoryData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// addSubCategory
exports.addSubCategory = (req, res) => {
    console.log("sub Category Body data", req.body)
    // Validate request
    if (!(req.body.name && req.body.parent)) {
        return res.status(400).send({ "is_error": true, "message": "All input is required" });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);

    console.log("loggedInUser", loggedInUser);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // // check if category already exist
        // // Validate if category exist in our database
        // const oldCat = await catModel.findOne({ 'name': req.body.name ,'created_by': loggedInUser.data.user_id, 'parent': req.body.parent });

        // if (oldCat) {
        // return res.status(409).send({"is_error": true , "message":  req.body.name + "Sub Category Already Exist" });
        // }
        // Create a sub category
        const catData = new catModel({
            name: req.body.name,
            created_by: loggedInUser.data.user_id,
            parent: req.body.parent,
            slug: slugify((req.body.name).toLowerCase())
        });

        // Save Category in the database
        catData.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
                return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while creating the category."
                });
            });
    } else {
        // Throw error
        return res.status(400).send({ "is_error": true, "message": "Unauthorized Access!" });
    }

};

// Get MY categories
exports.getMyCategories = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
        const categoryData = await catModel.find({ 'created_by': loggedInUser.data.user_id, 'parent': null }).sort([["updatedAt",-1]]);
        res.send({ is_error: false, data: categoryData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Get my sub categories by Cat id
exports.getMySubCategoriesByCatId = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
        const categoryData = await catModel.find({ 'created_by': loggedInUser.data.user_id, 'parent': req.params.cat_id }).sort([["updatedAt",-1]]);
        // const categoryData = await catModel.findOne({'_id':req.params.cat_id}).populate('parent');
        res.send({ is_error: false, data: categoryData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Update a user identified by the id in the request
exports.update = (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // Validate Request
    // Validate request
    if (!(req.body.name)) {
       return res.status(400).send({ "is_error": true, "message": "Category name can't be empty." });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // Create a category
        const catData = new catModel({
            name: req.body.name,
            created_by: loggedInUser.data.user_id,
            slug: slugify((req.body.name).toLowerCase())
        });
    }

    // Find note and update it with the request body
    catModel.findOneAndUpdate({ _id: req.params.id, created_by: loggedInUser.data.user_id }, {
        name: req.body.name,
        slug: slugify((req.body.name).toLowerCase())
    }, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Category not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Category not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Category " + err
            });
        });
};

// Delete a category & sub category with the specified id in the request
exports.delete = (req, res) => {
    console.log("params", req.params)
    // Delete category and its subcategories
    if (req.params && req.params.cat_id) {
        console.log("inside if params", req.params)
        catModel.findByIdAndRemove(req.params.cat_id)
            .then(responseData => {
                if (!responseData) {
                    return res.status(404).send({
                        is_error: true,
                        message: "No Category not found with id " + req.params.cat_id
                    });
                }
                catModel.deleteMany({ parent: req.params.cat_id }, function (err) {
                    if (err) {
                        console.log(err);
                        return res.status(404).send({
                            is_error: true,
                            message: "Error Occured:  " + err
                        });
                    }
                    console.log("Successful deletion");
                    res.send({ is_error: false, message: "Category Deleted successfully!" });
                });

            }).catch(err => {
                if (err.kind === 'ObjectId' || err.name === 'NotFound') {
                    return res.status(404).send({
                        is_error: true,
                        message: "Category not found with id " + req.params.cat_id
                    });
                }
                return res.status(500).send({
                    is_error: true,
                    message: "Could not delete with id " + req.params.cat_id
                });
            });
    }else{
        return res.send({ "is_error": true, "message": " Invalid Resource ID or resource id is missing. Please try again." });
    }

};
// Delete a category & sub category with the specified id in the request
exports.deleteSubcategory = (req, res) => {
    // Delete only subcategory
    if (req.params && req.params.cat_id && req.params.subcat_id) {
        catModel.findByIdAndRemove(req.params.subcat_id)
            .then(responseData => {
                if (!responseData) {
                    return res.status(404).send({
                        is_error: true,
                        message: "No Subcategory found with id " + req.params.subcat_id
                    });
                }
                res.send({ is_error: false, message: "Subcategory Deleted successfully!" });

            }).catch(err => {
                if (err.kind === 'ObjectId' || err.name === 'NotFound') {
                    return res.status(404).send({
                        is_error: true,
                        message: "No Subcategory found with id " + req.params.subcat_id
                    });
                }
                return res.status(500).send({
                    is_error: true,
                    message: "Could not delete with id " + req.params.subcat_id
                });
            });
    }else{
        return res.status(404).send({
            is_error: true,
            message: "Invalid subcategory id. Either Id is incorrect or not exist."
        }); 
    }

};