const companyModel = require('../model/company');
const hotelModel = require('../model/hotel');
const amenityModel = require('../model/facilities');
const roomModel = require('../model/rooms');


// Get all DB categories
exports.getDashboardData = async (req, res) => {
    try {
        const companies = await companyModel.find({}).count();
        const hotels = await hotelModel.find({}).count();
        const amenities = await amenityModel.find({}).count();
        const rooms = await roomModel.find({}).count();
        const dashboardData = {
            'companies':companies,
            'hotels':hotels,
            'amenities':amenities,
            'rooms':rooms
        }
        res.send({ is_error: false, data: dashboardData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};