var slugify = require('slugify')
const groupModel = require('../model/facilities');
const facilityTypeModel = require('../model/facilities_type');
const hotelModel = require('../model/hotel');


const helper = require('../middleware/_helper');

// Add Amenities/ Facility
exports.addAmenities = async (req, res) => {
    // console.log("Group Body data", req.body)
    // Validate request
    if (!(req.body.name)) {
        return res.status(400).send({ "is_error": true, "message": "Amenities name can't be empty." });
    }
    if (!(req.body.facility_type)) {
        return res.status(400).send({ "is_error": true, "message": "Please select facility type." });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // check if Group already exist
        // Validate if Group exist in our database
        const isDataExist = await groupModel.findOne({ 'name': req.body.name ,'section':req.body.section,'created_by': loggedInUser.data.user_id, 'parent': null });

        if (isDataExist) {
        return res.status(409).send({"is_error": true , "message":  req.body.name + "Already Exist" });
        }
        // Create a Facility Payload
        const groupDataPayload = new groupModel({
            name: req.body.name,
            facility_type: req.body.facility_type,
            description: req.body.description,
            created_by: loggedInUser.data.user_id,
            section: req.body.section ? req.body.section : 'both',
            useAsMainFilter: req.body.useAsMainFilter,
            icon: req.body.icon
        });

        // Save Group in the database
        groupDataPayload.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
               return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while creating the Amenities."
                });
            });
    }
};

exports.update = async (req, res) => {
    // console.log("req.body", req.body);
    // console.log("req.params", req.params)
    // Validate Request
    // Validate request
    if (!(req.body.name)) {
       return res.status(400).send({ "is_error": true, "message": "Amenities name can't be empty." });
    }
    if (!(req.body.facility_type)) {
        return res.status(400).send({ "is_error": true, "message": "Please select facility type." });
    }

    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);

    // Validate if Facility record exist in our database
    const oldRecord = await groupModel.findOne({  _id: { $ne: req.params.id } , 'name': req.body.name ,'created_by': loggedInUser.data.user_id });

    if (oldRecord) {
    return res.status(409).send({"is_error": true , "message":  req.body.name + " Already Exist." });
    }

    let payload = {
        name: req.body.name,
        facility_type: req.body.facility_type,
        description: req.body.description,
        created_by: loggedInUser.data.user_id,
        useAsMainFilter: req.body.useAsMainFilter,
        icon: req.body.icon
    };

    if(req.body.section){
        payload['section']= req.body.section ;
    }    

    // Find facility and update it with the request body
    groupModel.findOneAndUpdate({ _id: req.params.id, created_by: loggedInUser.data.user_id }, payload, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Amenities not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Amenities not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Amenities Deatails " + err
            });
        });
};

// Get all DB Amenities
exports.getAllAmenities = async (req, res) => {
    try {
    //     groupModel.updateMany({},{'useAsMainFilter':true} , {new: true})
    // .then(async response => {
    //     console.log("Success")
    // })
        const GroupData = await groupModel.find({ parent: { $eq: null }})
        .populate({path:'facility_type'})
        .sort([["updatedAt",-1]]);
        res.send({ is_error: false, data: GroupData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Get all DB Amenities
// exports.getAllAmenitiesbyType = async (req, res) => {
//     try {
//     //     groupModel.updateMany({},{'section':'property'} , {new: true})
//     // .then(async response => {
//     //     console.log("Success")
//     // })
//         // const amenetiesData = await facilityTypeModel.aggregate([
//         //     { $match: {  'is_active': true } },
//         //     {
//         //     $lookup: {
//         //         from: 'facilities',
//         //         localField: '_id',
//         //         foreignField: 'facility_type',
//         //         // pipeline:[{"$match":{"is_active":true,$or:[ {'section':'rooms'},{'section':'both'}]}}],
//         //         // pipeline:[{"$match":{section:'both'}}],
//         //         as: 'facilities'
//         //         }
//         //   },
//         //   {
//         //     $lookup: {
//         //       from: "hotels",
//         //       localField: "_id",
//         //       foreignField: "hotelFacilities",
//         //       as: "hotelRecords",
//         //     },
//         //   },
//         // ]);
//         const amenetiesData = await groupModel.aggregate([
//             { $match: {  'is_active': true , 'section': 'rooms'} },
//             // {
//             //     $lookup: {
//             //     from: "hotels",
//             //     localField: "_id",
//             //     foreignField: "hotelFacilities",
//             //     as: "hotelRecords",
//             //     },
//             // },
//             // {
//             //     $lookup: {
//             //     from: "rooms",
//             //     localField: "_id",
//             //     foreignField: "roomFacilities",
//             //     as: "rooms",
//             //     },
//             // },
//             {
//                 $lookup: {
//                 from: "facility_groups",
//                 localField: "facility_type",
//                 foreignField: "_id",
//                 as: "facilty_grp",
//                 },
//             },
//             {
//                 $group : { 
//                     _id : "$facilty_grp.group_name", 
//                    facilities: { $push: "$$ROOT" } 
//                 }
//             }
//         ]);
//         console.log("Ameneties Data", amenetiesData)
//         res.send({ is_error: false, data: amenetiesData });
//     } catch (error) {
//         console.log(error);
//         return res.send({ "is_error": true, "message": "An error occured : " + error });
//     }
// };

exports.getAllAmenitiesbyGroup= async (req, res) => {
    try {
   
        const AllAmenetiesData = await groupModel.aggregate([
            {"$match":{"is_active":true}},
            {
                $lookup: {
                from: "facility_groups",
                localField: "facility_type",
                foreignField: "_id",
                as: "facility_grp",
                },
            },
            {
                $group : { 
                    _id : "$facility_grp.group_name", 
                   facilities: { $push: "$$ROOT" } 
                }
            },
            {
                $sort:{_id:1}
            }
        ]);
        // console.log("Ameneties Data", AllAmenetiesData)
        res.send({ is_error: false, data: AllAmenetiesData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

exports.getRoomAmenities= async (req, res) => {
    try {
   
        const roomAmenetiesData = await groupModel.aggregate([
            {"$match":{"is_active":true,$or:[ {'section':'rooms'},{'section':'both'}, {'section':'Things to do'}]}},
            {
                $lookup: {
                from: "facility_groups",
                localField: "facility_type",
                foreignField: "_id",
                as: "facility_grp",
                },
            },
            {
                $group : { 
                    _id : "$facility_grp.group_name", 
                   facilities: { $push: "$$ROOT" } 
                }
            },
            {
                $sort:{_id:1}
            }
        ]);
        // console.log("Ameneties Data", roomAmenetiesData)
        res.send({ is_error: false, data: roomAmenetiesData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

exports.getHotelsAmenities= async (req, res) => {
    try {
   
        const hotelsAmenetiesData = await groupModel.aggregate([
            {"$match":{"is_active":true, $or:[ {'section':'property'},{'section':'both'}, {'section':'Things to do'}]}},
            {
                $lookup: {
                from: "facility_groups",
                localField: "facility_type",
                foreignField: "_id",
                as: "facility_grp",
                },
            },
            {
                $group : { 
                    _id : "$facility_grp.group_name", 
                   facilities: { $push: "$$ROOT" } 
                }
            },
            {
                $sort:{_id:1}
            }
        ]);
        // console.log("Ameneties Data", hotelsAmenetiesData)
        res.send({ is_error: false, data: hotelsAmenetiesData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// For front end website filters

exports.getAllAmenitiesbyGroupFilters= async (req, res) => {
    try {
   
        const AllAmenetiesData = await groupModel.aggregate([
            {"$match":{"is_active":true, "useAsMainFilter": true, }},
            {
                $lookup: {
                from: "facility_groups",
                localField: "facility_type",
                foreignField: "_id",
                as: "facility_grp",
                },
            },
            {
                $group : { 
                    _id : "$facility_grp.group_name", 
                   facilities: { $push: "$$ROOT" } 
                }
            },
            {
                $sort:{_id:1}
            }
        ]);
        // console.log("Ameneties Data", AllAmenetiesData)
        res.send({ is_error: false, data: AllAmenetiesData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

exports.getRoomAmenitiesFilters= async (req, res) => {
    try {
   
        const roomAmenetiesData = await groupModel.aggregate([
            {"$match":{"is_active":true,"useAsMainFilter": true, $or:[ {'section':'rooms'},{'section':'both'}, {'section':'Things to do'}]}},
            {
                $lookup: {
                from: "facility_groups",
                localField: "facility_type",
                foreignField: "_id",
                as: "facility_grp",
                },
            },
            {
                $group : { 
                    _id : "$facility_grp.group_name", 
                   facilities: { $push: "$$ROOT" } 
                }
            },
            {
                $sort:{_id:1}
            }
        ]);
        // console.log("Ameneties Data", roomAmenetiesData)
        res.send({ is_error: false, data: roomAmenetiesData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

exports.getHotelsAmenitiesFilters= async (req, res) => {
    try {
   
        const hotelsAmenetiesData = await groupModel.aggregate([
            {"$match":{"is_active":true, "useAsMainFilter": true, $or:[ {'section':'property'},{'section':'both'}, {'section':'Things to do'}]}},
            { $sort : { name : 1 } },
            {
                $lookup: {
                from: "facility_groups",
                localField: "facility_type",
                foreignField: "_id",
                as: "facility_grp",
                },
            },
            {
                $lookup: {
                from: "hotels",
                localField: "_id",
                foreignField: "hotelFacilities",
                as: "hotelsData",
                },
            },
            {"$addFields":{
                "hotel_counts":{$size: "$hotelsData"},
                "hotelsData": "$$REMOVE"
            }},
            {
                $group : { 
                    _id : "$facility_grp.group_name", 
                   facilities: { $push: "$$ROOT" } 
                }
            },
            {
                $sort:{_id:1}
            }
        ]);

        // const hotelsAmenetiesData = await hotelModel.aggregate([
        //     { "$unwind": "$hotelFacilities" },
        //     {
        //         $lookup: {
        //         from: "facility",
        //         localField: "hotelFacilities",
        //         foreignField: "_id",
        //         as: "facilitiesObj",
        //         },
        //     },
        //     { "$unwind": "$facilitiesObj" },
        //     { "$group": {
        //         "_id": "$facilitiesObj._id",
        //         // "hotelFacilities": { "$push": "$hotelFacilities" },
        //         "facilitiesObj": { "$push": "$facilitiesObj" }
        //     }},
        //     {
        //         $sort:{_id:1}
        //     }
        // ]);
        // console.log("Ameneties Data", hotelsAmenetiesData)
        res.send({ is_error: false, data: hotelsAmenetiesData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};


// Delete 
exports.delete = (req, res) => {
    groupModel.findByIdAndRemove(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Amenities not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Amenities deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Amenities not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Amenities with id " + req.params.id
        });
    });
};


// Change type status
exports.changeStatus = async (req, res) => {

    await groupModel.findByIdAndUpdate(req.params.id, {
        is_active: req.body.is_active
    }, { new: true })
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({ 'message': 'Status has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the status."
            });
        });
};

const XLSX = require('xlsx');
exports.dumpFacilities = async (req,res) => {
    var workbook = XLSX.readFile('./public/assets/mockData/facilities/facilities_modified.csv');
    var sheet_name_list = workbook.SheetNames;
    console.log("no. of sheets", sheet_name_list);
    const parsedData = XLSX.utils.sheet_to_json(workbook.Sheets[sheet_name_list[0]]) ;
    
    parsedData.forEach(async item => {
        let payload = {
            name: item.name,
            facility_type: item.facility_type,
            description: item.description,
            created_by: '61c1320f58e81b661c9d997e'
        }
        console.log("payload", payload)
        const dataRecord = new groupModel(payload);
        // Save record in the database
        await dataRecord.save();

    })
    console.log("Parsed daat length", parsedData.length)
    res.send({'parsedData': parsedData , 'total':parsedData.length})

};