var slugify = require('slugify')
const groupModel = require('../model/hotel_category');
const helper = require('../middleware/_helper');

// Add Property group
exports.addPropertyTypes = async (req, res) => {
    console.log("Group Body data", req.body)
    // Validate request
    if (!(req.body.property_type)) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Property Type name." });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // check if Group already exist
        // Validate if Group exist in our database
        const isDataExist = await groupModel.findOne({ 'slug': slugify((req.body.property_type).toLowerCase()),'created_by': loggedInUser.data.user_id, 'parent': null });

        if (isDataExist) {
        return res.status(409).send({"is_error": true , "message":  req.body.property_type + "Property Type Already Exist." });
        }
        // Create a Group
        const groupDataPayload = new groupModel({
            property_type: req.body.property_type,
            created_by: loggedInUser.data.user_id,
            slug: slugify((req.body.property_type).toLowerCase())
        });

        // Save Group in the database
        groupDataPayload.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
               return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while creating the Property Type."
                });
            });
    }
};

exports.update = async (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // Validate request
    if (!(req.body.property_type)) {
       return res.status(400).send({ "is_error": true, "message": "Property type name can't be empty." });
    }

    // Validate if Property type record exist in our database
    const oldRecord = await groupModel.findOne({  _id: { $ne: req.params.id } , 'slug': slugify((req.body.property_type).toLowerCase()) });
    console.log("old record", oldRecord)
    if (oldRecord) {
    return res.status(409).send({"is_error": true , "message":  req.body.property_type + " Already Exist." });
    }


    // Find Property type and update it with the request body
    groupModel.findOneAndUpdate({ _id: req.params.id }, {
        property_type: req.body.property_type,
        slug: slugify((req.body.property_type).toLowerCase())
    }, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Property Type not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Property Type not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Property Type " + err
            });
        });
};

// Get all DB Property Type groups
exports.getAllPropertyTypes = async (req, res) => {
    try {
        const GroupData = await groupModel.find({ parent: { $eq: null } }).sort([["updatedAt",-1]]);
        res.send({ is_error: false, data: GroupData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Delete 
exports.delete = (req, res) => {
    groupModel.findByIdAndRemove(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Property Type not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Property Type deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Property Type not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Property Type with id " + req.params.id
        });
    });
};

// Change type status
exports.changeStatus = async (req, res) => {

    await groupModel.findByIdAndUpdate(req.params.id, {
        is_active: req.body.is_active
    }, { new: true })
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({ 'message': 'Status has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the status."
            });
        });
};