const notificationModel = require('../model/notifications');
const User = require('../model/user');

const helper = require('../middleware/_helper');

  // Retrieve and return all my Notifications from the database.
  exports.getMyNotifications = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
        
        if (req.query.limit) {
            const limitCount = parseInt(req.query.limit);
            const notificationsList = await notificationModel.find( {'to_user_id':loggedInUser.data.user_id}).sort([["createdAt",-1]]).limit(limitCount);
            console.log("response data count", notificationsList.length)
            res.send({ is_error: false, data: notificationsList });
        }
        else {
            const notificationsList = await notificationModel.find( {'to_user_id':loggedInUser.data.user_id}).sort([["createdAt",-1]]);
            res.send({is_error : false, data: notificationsList });
        }
    } catch (error) {
        console.log(error);
        return res.send({is_error : true, message:"An error occured : " + error});
    }
  };

   // Retrieve and return all my Unread Notifications from the database.
   exports.getMyUnreadNotifications = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
        
        if (req.query.limit) {
            const limitCount = parseInt(req.query.limit);
            const notificationsList = await notificationModel.find( {'to_user_id':loggedInUser.data.user_id, 'unread':true}).sort([["updatedAt",-1]]).limit(limitCount);
            res.send({ is_error: false, data: notificationsList, unreadCount: notificationsList.length});
        }
        else {
            const notificationsList = await notificationModel.find( {'to_user_id':loggedInUser.data.user_id, 'unread':true}).sort([["updatedAt",-1]]);
            res.send({is_error : false, data: notificationsList, unreadCount: notificationsList.length });
        }
    } catch (error) {
        console.log(error);
        return res.send({is_error : true, message:"An error occured : " + error});
    }
  };

  // Change Notification status ( Read/ Unread)
exports.markNotificationAsRead = async (req, res) => {
    if (!req.body.notificationIds || req.body.notificationIds.length == 0) {
        return res.status(400).send("Please select any notification(s) for marking as read.");
      }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    
    await notificationModel.updateMany(
        { _id: { $in: req.body.notificationIds }, to_user_id : loggedInUser.data.user_id },
        { $set: { unread : false } },
        {multi: true}
     ).then(affectedRecords => {
        console.log('affeted records', affectedRecords)
        var msg = affectedRecords.modifiedCount + ' ' + 'Notification(s) marked as read.';
        res.send({'message': msg});
    }).catch(err => {
        return res.status(500).send({
            is_error: true,
            message: "Error while updating notifications status. Please try again."
        });
    });
};


// Create and Save a new notification - Testing Method
exports.create = async (req, res) => {
    console.log("notification Body data", req.body)
    // Validate request
    if (!(req.body.notifiction_title && req.body.notification_body)) {
        return res.status(400).send({ is_error: true , message: "Notifictation Title and Body all input is required" });
      }

    const payload = {
        notifiction_title: req.body.notifiction_title,
        notification_body: req.body.notification_body,
        type: req.body.type, // type: REMINDER, FREQUENCY
        event_id: req.body.event_id,
        to_user_id: req.body.to_user_id
      };
      

    // Create a notification
    const notification = new notificationModel(payload);

    // Save notification in the database
    notification.save()
    .then(data => {
        res.send({is_error : false, data:data});
    }).catch(err => {
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while creating Notification."
        });
    });
};

// Delete a Notification with the specified id in the request
exports.delete = (req, res) => {
    return res.status(500).send({
        is_error : true,
        message: "Temporary Disabled Delete feature."
    });
    notificationModel.findByIdAndRemove(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Notification not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Notification deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Notification not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Notification with id " + req.params.id
        });
    });
};

// Delete multiple a Notification with the specified id in the request
exports.deleteMultiple = async (req, res) => {
    if (!req.body.notificationIds || req.body.notificationIds.length == 0) {
        return res.status(400).send("Please select any notification(s) to delete.");
      }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    
    await notificationModel.deleteMany({ _id: { $in: req.body.notificationIds }, to_user_id : loggedInUser.data.user_id })
        .then(affectedRecords => {
        console.log('affeted records', affectedRecords)
        var msg = affectedRecords.deletedCount + ' ' + 'Notification(s) deleted successfully.';
        res.send({'message': msg});
    }).catch(err => {
        return res.status(500).send({
            is_error: true,
            message: "Error while deleting notifications. Please try again."
        });
    });
};