var slugify = require('slugify')
const pageModel = require('../model/page');

// Create and Save a new Page
exports.create = (req, res) => {
    console.log("page Body data", req.body)
    // Validate request
    if (!(req.body.page_title && req.body.page_content)) {
        return res.status(400).send({"is_error": true , "message": "All input is required."});
      }

    // Create a Page
    const page = new pageModel({
        page_title: req.body.page_title , 
        page_content: req.body.page_content,
        slug: slugify((req.body.page_title).toLowerCase())
    });

    // Save Page in the database
    page.save()
    .then(data => {
        res.send({is_error : false, data: data });
    }).catch(err => {
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while creating the page."
        });
    });
};

// Retrieve and return all pages from the database.
exports.findAll = async (req, res) => {
    try {
        const page = await pageModel.find({}).sort([["updatedAt",-1]]);
        res.send({is_error : false, data: page});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single page with a id
exports.findOne = (req, res) => {
    pageModel.findById(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Page not found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Page not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving page details with id " + req.params.id
        });
    });
};

// Find a single page with a slug
exports.findPageBySlug = (req, res) => {
    pageModel.findOne({'slug':req.params.slug})
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Page not found for " + req.params.slug
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Page not found for  " + req.params.slug
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving page for  " + req.params.slug
        });
    });
};

// Update a user identified by the id in the request
exports.update = (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // Validate Request
    if(!(req.body.page_title && req.body.page_content)) {
        return res.status(400).send({
            message: "All inputs are required. Please provide title and page content."
        });
    }

    // Find note and update it with the request body
    pageModel.findByIdAndUpdate(req.params.id, {
        page_title: req.body.page_title , 
        page_content: req.body.page_content,
        slug: slugify((req.body.page_title).toLowerCase())
    }, {new: true})
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Page not found with id " + req.params.id
            });
        }
        res.send( { is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Page not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error updating page with id " + err
        });
    });
};

// Delete a pageData with the specified id in the request
exports.delete = (req, res) => {
    pageModel.findByIdAndRemove(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Page not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Page deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Page not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete page with id " + req.params.id
        });
    });
};