const transactionModel = require('../model/transaction');

// Retrieve and return all Payment Transactions from the database.
exports.findAll = async (req, res) => {
    try {
        const transactionsData = await transactionModel.find({})
        .sort([["updatedAt",-1]]);
        res.send({is_error : false, data: transactionsData});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single Transaction Details with a id
exports.findOne = (req, res) => {
    transactionModel.findById(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Transaction Details not found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Transaction Details not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving Transaction Details with id " + req.params.id
        });
    });
};