
var moment = require('moment'); // require
const helper = require('../../middleware/_helper');
const hotelModel = require('../../model/hotel');
const roomModel = require('../../model/rooms');
const transactionModel = require('../../model/transaction');
const bookingModel = require('../../model/bookings');
const paymentIntentModel = require('../../model/payment-intent-initiate');

const emailCtrl = require('../../controllers/email.controller');
const email_templates = require('../../config/email_template_ids');

// import { nanoid } from 'nanoid'
const idGenerator = require('nanoid')

const stripe = require('stripe')(process.env.STRIPE_SECURITY_KEY);

 exports.makePayments = async (req, res) => {
    try {
        console.log("req.body inside v1.0 public payment ctrl", req.body)
        if(!(req.body.checkInOutDetails && req.body.traveller_information && req.body.room_basicDetails)){
            return res.status(400).send({ "is_error": true, "message": "Invalid Request. Please provide all the mandatory details." });
        }
        roomModel.findById(req.body.room_basicDetails.room_id)
        .then(async roomResponseDBData => {

            if (!roomResponseDBData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room Details Not available for provided Reference "
                });
            }
            const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
            console.log("logged in user", loggedInUser);
            const bookedByUserID = (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) ? loggedInUser.data.user_id : null ;
            const bookingId = idGenerator.nanoid(10) ;
            const metaDataObj = {
               ...req.body.checkInOutDetails ,
               ...req.body.traveller_information , 
               ...{
                  room_id: req.body.room_basicDetails.room_id,hotel_id: req.body.room_basicDetails.hotel_details._id, 
                  booking_id: bookingId,
                  bookedByUserID: bookedByUserID
                }
              } ;

            // return res.send(metaDataObj)
            // console.log("found Rooms details",roomResponseDBData)

            const pricebreakupItems = [];

            req.body.priceBreakup.forEach(element => {
              const item = {
                price_data: {
                  currency: 'usd',
                  product_data: {
                    name: req.body.room_basicDetails.room_name,
                    description: 'Resort: ' + req.body.room_basicDetails.hotel_details.name + ' ' + ',  ' + req.body.room_basicDetails.hotel_details.countryMetaData.name + ', ' + req.body.room_basicDetails.hotel_details.city
                  },
                  unit_amount: (element.payableAmt)*(req.body.checkInOutDetails.adultsCount) * 100,
                },
                quantity: req.body.checkInOutDetails.roomCount,
              }
              pricebreakupItems.push(item);
            });
            console.log(pricebreakupItems)

            const session = await stripe.checkout.sessions.create({
              payment_method_types: ['card'],
              client_reference_id: req.body.room_basicDetails.room_id + "_" + req.body.room_basicDetails.hotel_details._id,
              metadata: metaDataObj,
              line_items: pricebreakupItems,
              mode: 'payment',
              success_url: 'https://ctn.travel/booking/success/'+ bookingId,
              cancel_url: 'https://ctn.travel/booking/failed/'+ bookingId,
              // success_url: 'http://localhost:4200/booking/success/'+ bookingId,
              // cancel_url: 'http://localhost4200/booking/failed/'+ bookingId,
            });
            console.log("session Obj", session)

          // now save the data into payment intent collection

          const paymentIntentPayload = {
            room_id: req.body.room_basicDetails.room_id ,
            session_id: session.id,
            booking_id: bookingId, // generated unique booking code
            client_reference_id: req.body.room_basicDetails.room_id + "_" + req.body.room_basicDetails.hotel_details._id,
            userId: bookedByUserID,
            priceBreakup: pricebreakupItems, //hold price breakup details for future reference
            metaDataObj: metaDataObj ,// this will hold all booking details
            payment_intent: session.payment_intent
          }

            const paymentIntent = new paymentIntentModel(paymentIntentPayload);

            paymentIntent.save()
            .then(async results => {
              return res.json({ sessionObj: session,id: session.id });
            }).catch(err => {
                console.log("Booking records save error", err);
              res.status(500).send({
                is_error: true,
                message: err.message || "Some error occurred while initiating the payment. Please try after some time."
              });
            });

        }).catch(err => {
          console.log('err', err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room Details Not available for provided Reference."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details please try after sometime ! "
            });
        });
        
    } catch (error) {
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
  }


  let endpointSecret;
 exports.onTransactionComplete = async (req, res) => {
  console.log("payment callback Body data")
 if(!req.body.data){
  return res.status(400).send('Response body cant be empty');
 }
  const sig = req.headers['stripe-signature'];
  console.log("webhook end point called")
  let eventType;
  let data;
  if (endpointSecret) {
    let event;

    try {
      event = stripe.webhooks.constructEvent(req.body, sig, endpointSecret);
      console.log(`Webhook Verified: ${data}`)
    } catch (err) {
      console.log(`Webhook Error: ${err.message}`)
      res.status(400).send(`Webhook Error: ${err.message}`);
      return;
    }
    data = event.data.object;
    eventType = event.type;
  } else {
    data = req.body.data.object;
    eventType = req.body.type;
  }


  // Handle the event
  switch (eventType) {
    case 'payment_intent.succeeded':
      const paymentIntent = data;
      // Then define and call a function to handle the event payment_intent.succeeded
      console.log("Payment Intent success:")
      // Return a 200 response to acknowledge receipt of the event
      res.send("On payment_intent succeeded complete Method");
      break;
    case 'checkout.session.completed':
      // Then define and call a function to handle the event payment_intent.succeeded
      console.log("Checkout success:", data)
      // Here just update the checkout session status to complete in payment intent Table
      const foundIntent_details = await paymentIntentModel.findOne({ payment_intent: data.payment_intent ,session_id: data.id });
      if(foundIntent_details){
        const modificationSuccess = await paymentIntentModel.findByIdAndUpdate(foundIntent_details._id, {isCompleted: true}, {new: true}).exec();
        // Email Notification to CTN Admin
        const emailData = {
          msg: {
              to: ['shivam201065@gmail.com', process.env.SUPPORT_EMAIL],
              from: process.env.SUPPORT_EMAIL, // Use the email address or domain you verified above
              template_id: email_templates.ADMIN_BOOKING_CONFIRMATION_NOTIFICATION,
              dynamic_template_data:{
                  "subject":"CTN-New Room Booking Confirmation",
                  "first_name":foundIntent_details.metaDataObj.firstName,
                  "last_name": foundIntent_details.metaDataObj.lastName,
                  "room_name":"",
                  "booking_id":foundIntent_details.booking_id,
                  "checkIn":foundIntent_details.checkInDate,
                  "checkOut":foundIntent_details.checkOutDate,
                  "rooms_count" : foundIntent_details.roomCount,
                  "adults_count": foundIntent_details.adultsCount,
                  "transaction_id": "",
                  "booking_amount":0
              }
            }
        }
        console.log("email Data", emailData)
        // send Email to User with OTP
        emailCtrl.sendEmail(emailData);

      }
      res.send({message: "On checkout session complete" });

      break;
    case 'charge.succeeded':
    // Then define and call a function to handle the event payment_intent.succeeded
    console.log("charge.succeeded:", data)
      const paymentIntenetDetails = await paymentIntentModel.findOne({ payment_intent: data.payment_intent });
      if(paymentIntenetDetails){
        
        // Now Save the Transaction entry into DB
        // Create Transaction Payload to save into Transaction DB.
          const payload = {
            transaction_id: data.payment_intent,
            amount: data.amount,
            currency: data.currency,
            payment_status: data.status,
            paid: data.paid,
            payment_method: data.payment_method_details.type,
            payment_method_details: data.payment_method_details,
            gateway_response: data,
            receipt_url: data.receipt_url,
            billing_details: data.billing_details,
            user_id: paymentIntenetDetails.userId
        }
        // Record Transaction Data
        const transactionRecord = new transactionModel(payload);
        // Save Transaction details in the transaction Table database
        transactionRecord.save()
        .then(async transactiondata => {
            console.log("Transaction details has been saved in DB record", transactiondata)
          // Now save the Booking entry into DB
            console.log("Payment Intent Details", paymentIntenetDetails)
          // saving record in Booking table with unique payment intent and payment status as PENDING
          const bookingPayload = {
            bookingId: paymentIntenetDetails.booking_id ,
            room_id: paymentIntenetDetails.metaDataObj.room_id ,
            hotel_id:  paymentIntenetDetails.metaDataObj.hotel_id,
            transaction_id: transactiondata._id,
            transaction_status: transactiondata.payment_status,
            booking_type: 'ONLINE',
            cs_id: data.id,
            strp_pyintnt_refid: transactiondata.transaction_id,
            amount: transactiondata.amount,
            currency: transactiondata.currency,
            bookedBy: transactiondata.user_id,
            booking_status: transactiondata.payment_status === 'succeeded' ? 'CONFIRMED' : 'PENDING',
            checkIn: paymentIntenetDetails.metaDataObj.checkInDate,
            checkOut: paymentIntenetDetails.metaDataObj.checkOutDate,
            checkInTime: paymentIntenetDetails.metaDataObj.checkInTime,
            checkOutTime:paymentIntenetDetails.metaDataObj.checkOutTime,
            adults: paymentIntenetDetails.metaDataObj.adultsCount,
            children: paymentIntenetDetails.metaDataObj.childernCount,
            number_of_rooms: paymentIntenetDetails.metaDataObj.roomCount,
            special_request: paymentIntenetDetails.metaDataObj.special_request,
            guestDetails:[{
                firstName:paymentIntenetDetails.metaDataObj.firstName,
                lastName: paymentIntenetDetails.metaDataObj.lastName,
                email: paymentIntenetDetails.metaDataObj.email,
                mobile: paymentIntenetDetails.metaDataObj.mobile,
                DOB: paymentIntenetDetails.metaDataObj.checkOutDate,
                nationality: paymentIntenetDetails.metaDataObj.nationality,
                physically_challanged: paymentIntenetDetails.metaDataObj.physically_challanged,
                physically_challanged_description: paymentIntenetDetails.metaDataObj.physically_challanged_description
            }],
            billing_address: transactiondata.billing_details,
            roomDetailsSnapshot: {}
        }
        
        // Record Booking Data
        const booking = new bookingModel(bookingPayload);

        // Save Booking details in the booking database
        booking.save()
          .then(async results => {
              console.log("boking details has been saved in DB record")
                // Now here Send emails to Customer 1) Payment Success 2) Booking Confirmed
                const emailData = {
                  msg: {
                      to: ['shivam201065@gmail.com', results.guestDetails[0].email],
                      from: process.env.SUPPORT_EMAIL, // Use the email address or domain you verified above
                      template_id: email_templates.BOOKING_CONFIRMED,
                      dynamic_template_data:{
                          "subject":"CTN Booking Confirmed !",
                          "first_name":results.guestDetails[0].firstName,
                          "last_name":results.guestDetails[0].lastName,
                          "room_name":"",
                          "booking_id":results.bookingId
                      }
                    }
              }
              console.log("email Data", emailData)
              // send Email to User with OTP
              emailCtrl.sendEmail(emailData);

            // 
            // Return a 200 response to acknowledge receipt of the event
            res.send({ data: results, message: "On Charge Succeeeded complete Method" });
          }).catch(err => {
              console.log("Booking records save error", err);
            res.status(500).send({
              is_error: true,
              message: err.message || "Some error occurred while recording transaction data."
            });
          });
        
          // Return a 200 response to acknowledge receipt of the event
          // res.send({ data: transactiondata, message: "On Charge Succeeeded complete Method" });
        }).catch(err => {
        console.log("transaction records save error", err);
          res.status(500).send({
            is_error: true,
            message: err.message || "Some error occurred while recording transaction data."
          });
        });
      }

    // Return a 200 response to acknowledge receipt of the event
  //   return res.send("Charge Succeeded -On Transaction complete Method");
    break;
    // ... handle other event types
    default:
      console.log(`Unhandled event type ${eventType}`);
      // Return a 200 response to acknowledge receipt of the event
      res.send("Default case -On Transaction complete Method");
  }


};


// Find a booking and transaction details with client secret id
exports.getBookingTransactionDetails = (req, res) => {

    bookingModel.findOne({'bookingId':req.params.bookingId})
        .populate({
           path: 'hotel_id', 
           select: ["name","countryMetaData","city","rating","slug",'checkIn','checkOut','property_class','property_type','property_brand'],
        })
        .populate({ 
          path: 'room_id' , 
          select:["name","cat_code","mainPhoto","hotel_id"],
          populate:[{ path: 'mainPhoto'} ],
          populate:[{  path: 'hotel_id', 
          select: ["name","countryMetaData","city","rating","slug",'checkIn','checkOut','property_class','property_type','property_brand']} ]

        })
        .populate({ path: 'transaction_id', select: ["receipt_url"] })
        .then(async response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Booking Transaction details not found .Please contact with Administrator."
                });
            }
            res.send({is_error : false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Booking Transaction details not found .Please contact with Administrator."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Booking Transaction details not found .Please contact with Administrator."
            });
        });
};
