var slugify = require('slugify')
var mongoose = require('mongoose');
const roomModel = require('../../model/rooms');
const hotelModel = require('../../model/hotel');
const mediaModel = require('../../model/rooms_images');
const roomLevelModel = require('../../model/room_subcategory_group');

const helper = require('../../middleware/_helper');
const mediaUtils = require("../../config/unlinkMedia");

// var moment = require('moment'); // require
var moment = require('moment-timezone');

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')

// Retrieve and return all room from the database.
exports.findAll = async (req, res) => {
    // roomModel.updateMany({'room_subcat_group':'BE'}, {'room_subcat_group':'644f3e965ef971971de5d9e7'} , {new: true})
    // .then(async response => {
    //     console.log("Success")
    // })
    try {
        console.log("req.query rooms", req.query)
        console.log("exact query",mongoose.Types.ObjectId(req.query.hotel_id))
        // var query = (req.query.hotel_id) ? req.query : {}

        var query = {'hotel_id': mongoose.Types.ObjectId(req.query.hotel_id),'price': {$ne:0},
        'selling_price': {$ne:0}};
        if(req.query.roomLevel != ''){
            query['room_subcat_group'] = mongoose.Types.ObjectId(req.query.roomLevel)
        }
        var sortBy = (req.query.priceSort && req.query.priceSort == 'asc') ? 1 : -1 ; 
        // added condition for stop sale and inactive rooms - not to include in results
        query['is_available'] = true ;

        // const rooms = await roomModel.find(query)
        //     .populate({ path: 'hotel_id', select: ["name"] })
        //     .populate({ path: 'room_cat_group', select: ["group_name"] })
        //     .populate({ path: 'room_subcat_group', select: ["group_name"] })
        //     .sort([["updatedAt", -1]]);
        const rooms = await roomModel.aggregate([
            { $match: query },
            {$sort: {"selling_price": sortBy}},
            {
                $lookup: {
                    from: 'rooms_images',
                    localField: '_id',
                    foreignField: 'ref_id',
                    // pipeline:[{"$match":{"deleted":false}}],
                    as: 'media'
                }
            },
            {
                 
                $lookup: {
                    from: 'rooms_images',
                    localField: 'BannerPhoto',
                    foreignField: '_id',
                    as: 'BannerPhoto'
                }
            },
            {
                $lookup: {
                    from: 'rooms_images',
                    localField: 'mainPhoto',
                    foreignField: '_id',
                    as: 'mainPhoto'
                }
            },
            {
                 $lookup: {
                    from: 'room_subcategory_groups',
                    localField: 'room_subcat_group',
                    foreignField: '_id',
                    as: 'room_levels'
                }
            },
            {
                $lookup: {
                   from: 'facilities',
                   localField: 'highlightedFacilities',
                   foreignField: '_id',
                   as: 'highlightedFacilities'
               }
           }
        ]);
        // console.log("rooms", rooms)
        res.send({ is_error: false, data: rooms });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a single Room Details with room id
exports.findOne = (req, res) => {
    roomModel.findById(req.params.id)
        .then(async response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found with id " + req.params.id
                });
            }
            const projectMedia = await mediaModel.find({ref_id: req.params.id});
            console.log("projectMedia", projectMedia);
            response.mediaFiles = projectMedia ;
            res.send({is_error : false, data: response, mediaFiles: projectMedia });
            // res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details with id " + req.params.id
            });
        });
};

// Find a single Room with a slug
exports.findRoomBySlug = async (req, res) => {
    roomModel.findOne({ 'slug': req.params.slug, 'is_available': true })
        .populate({ path: 'hotel_id', select: ["name","countryMetaData","city","rating","slug"] })
        .populate({ path: 'room_cat_group', select: ["group_name"] })
        .populate({ path: 'room_subcat_group', select: ["group_name"] })
        // .populate({ path: 'roomFacilities'})
        .populate({ path: 'mainPhoto'})
        .populate({ path: 'BannerPhoto'})
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for " + req.params.slug
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            console.log(err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for  " + req.params.slug
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details for  " + req.params.slug
            });
        });

    // const roomDetails = await roomModel.aggregate([
    //     { $match: {  'slug': req.params.slug } },
    //     {
    //     $lookup: {
    //         from: 'rooms_image',
    //         localField: '_id',
    //         foreignField: 'ref_id',
    //         // pipeline:[{"$match":{"deleted":false}}],
    //         as: 'media'
    //     }
    // }]);
    // res.send({ is_error: false, data: roomDetails });
};

exports.getRoomImages = async (req, res) => {
    const roomImagesdata = await mediaModel.find({ref_id: req.params.roomId ,deleted: false });
    res.send({ is_error: false, data: roomImagesdata });
};

exports.getRoomLevels = async (req, res) => {
    try {
        const roomLevelsData = await roomLevelModel.find({ parent: { $eq: null } }).sort([["group_name",-1]]);
        res.send({ is_error: false, data: roomLevelsData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};


// Get Room details with Price data for Booking
exports.getBookingRoomPriceData = async (req, res) => {
    roomModel.findOne({ '_id': req.params.roomId })
        .populate({ 
            path: 'hotel_id', 
            select: ["name","countryMetaData","city","rating","slug",'checkIn','checkOut','property_class','property_type','property_brand'],
            populate:[{ path: 'property_type'} ]
        })
        .populate({ path: 'room_cat_group', select: ["group_name"] })
        .populate({ path: 'room_subcat_group', select: ["group_name"] })
        .populate({ path: 'roomFacilities'})
        .populate({ path: 'mainPhoto'})
        .populate({ path: 'BannerPhoto'})
        .select("-__v -createdAt -updatedAt -priceList -externalVideoList -discount_percent -ctn_markup_percent -agent_markdown_percent -price")
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for " + req.params.roomId
                });
            }
            // find the room price for the current duration
            res.send({ is_error: false, data: response });
        }).catch(err => {
            console.log(err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for  " + req.params.roomId
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details for  " + req.params.roomId
            });
        });
};

exports.getCurrentRoomRates = async (req, res) => {
    try {
        console.log("Get current room rates", req.body)
        roomModel.findById(req.body.id)
        .then(async roomResponseDBData => {
            if (!roomResponseDBData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room Details Not available for provided Reference "
                });
            }
            // console.log("found Rooms details",roomResponseDBData)
            const effectivePriceList = [];
            const checkIndate = moment(req.body.checkInDate).set({ hour: 0, minute: 0, second: 0, millisecond: 0 });
            const checkOutDate = moment(req.body.checkOutDate).set({ hour: 0, minute: 0, second: 0, millisecond: 0 });
            console.log("checkIndate",checkIndate)
            console.log("checkOutDate",checkOutDate)
            roomResponseDBData.priceList.forEach (async priceData => {

            //   const isBetweenCheckInDate =  moment(checkIndate).isBetween(priceData.startDate, priceData.endDate, undefined , '[]');
            //   const isBetweenCheckOutDate =  moment(checkOutDate).isBetween(priceData.startDate, priceData.endDate,undefined , '[]');
            const UTC_CheckIN = moment(req.body.checkInDate).utc();
            const UTC_CheckOUT = moment(req.body.checkInDate).utc();
            const UTC_Price_StartDate = moment(req.body.checkInDate).utc();
            const UTC_Price_EndDate = moment(req.body.checkInDate).utc();
            console.log("UTC_CheckIN", moment(req.body.checkInDate).format('YYYY-MM-DD'))
            // check if Price start date and end date lies b/w chekc in and checkout range
              const isBetweenStartDate =  moment(priceData.startDate).isBetween(req.body.checkInDate, req.body.checkOutDate,undefined , '[]');
              const isBetweenEndDate =  moment(priceData.endDate).isBetween(req.body.checkInDate, req.body.checkOutDate,undefined , '[]');
            //   console.log("isstartDateBetweenDate",isBetweenStartDate);
            //   console.log("isBetweenCheckOutDate",isBetweenEndDate);
              
              if(isBetweenEndDate){
                console.log("Checkin date in betweeen this Price list",priceData.price);
                // check if Data already present in effective list or not
                const matchedItem = effectivePriceList.filter(item =>{
                  return item._id === priceData._id
                })
                console.log("already present", matchedItem);
                if(matchedItem.length === 0){
                    const ctn_cost_discounted_price = Math.round(priceData.price) - (((roomResponseDBData.discount_percent) * Math.round(priceData.price)) / 100);
                    const ctn_markup_price = ((roomResponseDBData.ctn_markup_percent) * ctn_cost_discounted_price) / 100;
                    const ctn_selling_price = ctn_cost_discounted_price + ctn_markup_price ;
                    priceData.price = Math.round(ctn_selling_price) ;
                    if(moment(req.body.checkInDate).isSameOrAfter(priceData.startDate))
                    {
                        priceData.startDate = req.body.checkInDate ;
                    }
                    if(moment(req.body.checkOutDate).isBefore(priceData.endDate))
                    {
                        priceData.endDate = req.body.checkOutDate ;
                    }
                    effectivePriceList.push(priceData);
                }
              }

              if(isBetweenStartDate){
                console.log("Checkout date in betweeen this Price list",priceData.price);
                 // check if Data already present in effective list or not
                 const matchedItem = effectivePriceList.filter(item =>{
                  return item._id === priceData._id
                })
                console.log("already present", matchedItem)
                if(matchedItem.length === 0){
                    const ctn_cost_discounted_price = Math.round(priceData.price) - (((roomResponseDBData.discount_percent) * Math.round(priceData.price)) / 100);
                    const ctn_markup_price = ((roomResponseDBData.ctn_markup_percent) * ctn_cost_discounted_price) / 100;
                    const ctn_selling_price = ctn_cost_discounted_price + ctn_markup_price ;
                    priceData.price = Math.round(ctn_selling_price) ;
                    if(moment(req.body.checkInDate).isSameOrAfter(priceData.startDate))
                    {
                        priceData.startDate = req.body.checkInDate ;
                    }
                    if(moment(req.body.checkOutDate).isBefore(priceData.endDate))
                    {
                        priceData.endDate = req.body.checkOutDate ;
                    }
                  effectivePriceList.push(priceData);
                }
                // effectivePriceList.push(priceData);
              }

               // check if checkin checkout lies b/w price start and end date range
              const isBetweenCheckInDate =  moment(req.body.checkInDate).isBetween(priceData.startDate, priceData.endDate,undefined , '[]');
              const isBetweenCheckOutDate =  moment(req.body.checkOutDate).isBetween(priceData.startDate, priceData.endDate,undefined , '[]');
            //   console.log("isstartDateBetweenDate",isBetweenCheckInDate);
            //   console.log("isBetweenCheckOutDate",isBetweenCheckOutDate);
              
              if(isBetweenCheckOutDate){
                console.log("Checkin date in betweeen this Price list",priceData.price);
                // check if Data already present in effective list or not
                const matchedItem = effectivePriceList.filter(item =>{
                  return item._id === priceData._id
                })
                console.log("already present", matchedItem);
                if(matchedItem.length === 0){
                    const ctn_cost_discounted_price = Math.round(priceData.price) - (((roomResponseDBData.discount_percent) * Math.round(priceData.price)) / 100);
                    const ctn_markup_price = ((roomResponseDBData.ctn_markup_percent) * ctn_cost_discounted_price) / 100;
                    const ctn_selling_price = ctn_cost_discounted_price + ctn_markup_price ;
                    priceData.price = Math.round(ctn_selling_price) ;
                    if(moment(req.body.checkInDate).isSameOrAfter(priceData.startDate))
                    {
                        priceData.startDate = req.body.checkInDate ;
                    }
                    if(moment(req.body.checkOutDate).isBefore(priceData.endDate))
                    {
                        priceData.endDate = req.body.checkOutDate ;
                    }
                    effectivePriceList.push(priceData);
                }
              }

              if(isBetweenCheckInDate){
                console.log("Checkout date in betweeen this Price list",priceData.price);
                 // check if Data already present in effective list or not
                 const matchedItem = effectivePriceList.filter(item =>{
                  return item._id === priceData._id
                })
                console.log("already present", matchedItem)
                if(matchedItem.length === 0){
                    const ctn_cost_discounted_price = Math.round(priceData.price) - (((roomResponseDBData.discount_percent) * Math.round(priceData.price)) / 100);
                    const ctn_markup_price = ((roomResponseDBData.ctn_markup_percent) * ctn_cost_discounted_price) / 100;
                    const ctn_selling_price = ctn_cost_discounted_price + ctn_markup_price ;
                    priceData.price = Math.round(ctn_selling_price) ;
                    if(moment(req.body.checkInDate).isSameOrAfter(priceData.startDate))
                    {
                        priceData.startDate = req.body.checkInDate ;
                    }
                    if(moment(req.body.checkOutDate).isBefore(priceData.endDate))
                    {
                        priceData.endDate = req.body.checkOutDate ;
                    }
                  effectivePriceList.push(priceData);
                }
                // effectivePriceList.push(priceData);
              }


            //   #######################################################################################

              // console.log("price id", priceData._id ) ;
              // console.log("price applicable", priceData.price ) ;
              // console.log("Check In Date  ###########", req.body.checkInOutDetails.checkInDate);
              // console.log("CheckOut date  ###########", req.body.checkInOutDetails.checkOutDate);
              // if(isBetweenDate){
              //   console.log("Price Found for currrent date time", Math.round(priceData.price));
              //   const ctn_cost_discounted_price = Math.round(priceData.price) - (((elem.discount_percent) * Math.round(priceData.price)) / 100);
              //   const ctn_markup_price = ((elem.ctn_markup_percent) * ctn_cost_discounted_price) / 100;
              //   const ctn_selling_price = ctn_cost_discounted_price + ctn_markup_price ;
              //   const querySucess = await roomModel.updateOne({_id:elem._id}, {$set:{price: Math.round(priceData.price) , selling_price: ctn_selling_price}}, { timestamps: false }).exec();
              // }
            });

           return res.json({ 'effectivePriceList': effectivePriceList });
        }).catch(err => {
          console.log('err', err)
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room Details Not available for provided Reference."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details please try after sometime ! "
            });
        });
        
    } catch (error) {
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
  }
