const companyModel = require('../model/company');
const hotelModel = require('../model/hotel');
const roomModel = require('../model/rooms');

const mediaModel = require('../model/rooms_images');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')

/// Create and Save a new Company
exports.create = (req, res) => {
    console.log("Company Body data", req.body)
    // Validate request
    if (!req.body.company_name) {
        return res.status(400).send({"is_error": true , "message": "Please provide the name of company."});
      }
    
    if(req.files && req.files['company_logo']){
        const mediaRootPath = "public/uploads/company_logo/";
        const path =  mediaRootPath + req.files['company_logo'][0].filename;
        req.body.company_logo = path ;
    }

    // Create a Company
    const companyRecord = new companyModel({
        company_name: req.body.company_name , 
        email: req.body.email,
        phone: req.body.phone,
        international_phone: req.body.international_phone,
        address_line: req.body.address_line,
        address_line2: req.body.address_line2,
        contact_first_name: req.body.contact_first_name,
        contact_last_name: req.body.contact_last_name,
        web_url: req.body.web_url,
        latitude: req.body.latitude,
        longitude: req.body.longitude,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code ? req.body.zip_code : '',
        company_logo: req.body.company_logo,
        about_us: req.body.about_us,
        privacy_policy: req.body.privacy_policy,
        terms_and_conditions: req.body.terms_and_conditions,
        countryMetaData: JSON.parse(req.body.countryMetaData),
        stateMetaData: JSON.parse(req.body.stateMetaData),
        cityMetaData: JSON.parse(req.body.cityMetaData),
    });

    // Save Company in the database
    companyRecord.save()
    .then(data => {
        res.send({is_error : false, data: data });
    }).catch(err => {
        if(req.files && req.files['company_logo']){
            const mediaRootPath = "public/uploads/company_logo/";
            const path =  mediaRootPath + req.files['company_logo'][0].filename;
            // delete all media from folder
            mediaUtils.unlink(path);
          }
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while creating the Company."
        });
    });
};

// Retrieve and return all Companies from the database.
exports.findAll = async (req, res) => {
    try {
        const companies = await companyModel.find({is_deleted: false}).sort([["updatedAt",-1]]);
        res.send({is_error : false, data: companies});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single Company Details with a id
exports.findOne = (req, res) => {
    companyModel.findById(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Company details not found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Company details not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving Company details with id " + req.params.id
        });
    });
};


// Update Company details
exports.update = (req, res) => {

console.log("req.files", req.files)
  // Validate request
  if (!req.body.company_name) {
    return res.status(400).send({"is_error": true , "message": "Please provide Company name."});
  }

// Create a Company
const companyRecord = {
    company_name: req.body.company_name , 
    email: req.body.email,
    phone: req.body.phone,
    international_phone: req.body.international_phone,
    address_line: req.body.address_line,
    address_line2: req.body.address_line2,
    contact_first_name: req.body.contact_first_name,
    contact_last_name: req.body.contact_last_name,
    web_url: req.body.web_url,
    latitude: req.body.latitude,
    longitude: req.body.longitude,
    country: req.body.country,
    state: req.body.state,
    city: req.body.city,
    zip_code: req.body.zip_code,
    about_us: req.body.about_us,
    privacy_policy: req.body.privacy_policy,
    terms_and_conditions: req.body.terms_and_conditions,
    countryMetaData: JSON.parse(req.body.countryMetaData),
    stateMetaData: JSON.parse(req.body.stateMetaData),
    cityMetaData: JSON.parse(req.body.cityMetaData),
};

console.log("payload to save", companyRecord)

    // Find Company and update it with the request body
    companyModel.findByIdAndUpdate(req.params.id, companyRecord, {new: true})
    .then(async response => {
        console.log("response", response)
        console.log("inside suceess", req.files)
        if(req.files && req.files['company_logo']){
            const mediaRootPath = "public/uploads/company_logo/";
            const path =  mediaRootPath + req.files['company_logo'][0].filename;
            const newcompany_logo = path ;
            // check if logo is already set then delete the media from folder
            if(response.company_logo  && response.company_logo != ''){
                mediaUtils.unlink(response.company_logo);
            }
            await companyModel.findByIdAndUpdate(req.params.id, {company_logo: newcompany_logo}, {new: true}).exec();
          }
        if(!response) {
            if(req.files && req.files['company_logo']){
                const mediaRootPath = "public/uploads/company_logo/";
                const path =  mediaRootPath + req.files['company_logo'][0].filename;
                // delete all media from folder
                mediaUtils.unlink(path);
              }
            return res.status(404).send({
                is_error : true,
                message: "Company not found with id " + req.params.id
            });
        }
        res.send( { is_error : false, data: response });
    }).catch(err => {
        if(req.files && req.files['company_logo']){
            const mediaRootPath = "public/uploads/company_logo/";
            const path =  mediaRootPath + req.files['company_logo'][0].filename;
            // delete all media from folder
            mediaUtils.unlink(path);
          }
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Company not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error updating Company with id " + err
        });
    });
};

// Delete a Company with the specified id in the request
exports.delete = (req, res) => {
    companyModel.findByIdAndRemove(req.params.id)
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Company not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Company deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.company_name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Company not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Company with id " + req.params.id
        });
    });
};

// Change project status
exports.changeStatus = async (req, res) => {

    await companyModel.findByIdAndUpdate(req.params.company_id, {
        is_active: req.body.is_active
    }, { timestamps: false })
        .then( async responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Company Details."
                });
            }
            const hotelsrecords_success = await hotelModel.updateMany({company_id:req.params.company_id },{'is_active':req.body.is_active}, { timestamps: false }).exec();
            const allHotels = await hotelModel.find({company_id:req.params.company_id }).exec();
            console.log("alHotels", allHotels.length)
            allHotels.forEach(async element => {
                const roomRecords_success = await roomModel.updateMany({hotel_id:element._id },{'is_available':req.body.is_active}, { timestamps: false }).exec();
            });
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({'message': 'Company has been marked as' +' '+ notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Company details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the Company status."
            });
        });
};

exports.getCompaniesDropdown = async (req, res) => {
    try {
        const companies = await companyModel.find({}).select('-email -phone -country  -city -state -zip_code -__v -createdAt -updatedAt').sort([["company_name",-1]])
        res.send({is_error : false, data: companies});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
}