
const contactUsModel = require('../model/ctn_contact_us');
const helper = require('../middleware/_helper');

// Add contact Us deta
exports.add = async (req, res) => {
        console.log("req.body", req.body)
        // Create a Group
        const payload = new contactUsModel( {
            usa_communication_details: req.body.usa_communication_details,
            caribbean_communication_details: req.body.caribbean_communication_details,
            general_communication_details: req.body.general_communication_details,
            social_profiles:{
              facebook: req.body.social_profiles.facebook,
              twiter: req.body.social_profiles.twiter,
              instagram: req.body.social_profiles.instagram,
              linkedin: req.body.social_profiles.linkedin,
            },
            embed_google_map: {
              small:req.body.embed_google_map.small,
              medium: req.body.embed_google_map.medium,
              large: req.body.embed_google_map.large
            }
           
          }
          );
          console.log("add payload",payload)

        // Save contact us details into database
        payload.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
                console.log(err)
               return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while saving contact us details."
                });
            });
};
// update contact us details
exports.update = async (req, res) => {
    console.log("req.body", req.body);

     // Create a Group
     const payload = {
            usa_communication_details: req.body.usa_communication_details,
            caribbean_communication_details: req.body.caribbean_communication_details,
            general_communication_details: req.body.general_communication_details,
            social_profiles:{
              facebook: req.body.social_profiles.facebook,
              twiter: req.body.social_profiles.twiter,
              instagram: req.body.social_profiles.instagram,
              linkedin: req.body.social_profiles.linkedin,
            },
            embed_google_map: {
              small:req.body.embed_google_map.small,
              medium: req.body.embed_google_map.medium,
              large: req.body.embed_google_map.large
            }
           
          };
      console.log("update payload",payload)


    // Find Town and update it with the request body
    contactUsModel.findOneAndUpdate({ _id: req.params.id }, payload, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Details not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Details not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating contact Details " + err
            });
        });
};

// Get getContactusDetails
exports.getContactusDetails = async (req, res) => {
    try {
        const contactUsDetails = await contactUsModel.find({});
        res.send({ is_error: false, data: contactUsDetails });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};