var slugify = require('slugify')
const groupModel = require('../model/facilities_type');
const helper = require('../middleware/_helper');

// Add facility group
exports.addgroup = async (req, res) => {
    console.log("Group Body data", req.body)
    // Validate request
    if (!(req.body.group_name)) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Facility Type name." });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // check if Group already exist
        // Validate if Group exist in our database
        const isDataExist = await groupModel.findOne({ 'slug': slugify((req.body.group_name).toLowerCase()),'created_by': loggedInUser.data.user_id, 'parent': null });

        if (isDataExist) {
        return res.status(409).send({"is_error": true , "message":  req.body.group_name + "Facility Type Already Exist." });
        }
        // Create a Group
        const groupDataPayload = new groupModel({
            group_name: req.body.group_name,
            created_by: loggedInUser.data.user_id,
            slug: slugify((req.body.group_name).toLowerCase()),
            group_type: req.body.group_type ? req.body.group_type : 'STANDARD'
        });

        // Save Group in the database
        groupDataPayload.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
               return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while creating the Facility Type."
                });
            });
    }
};

exports.update = async (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // Validate Request
    // Validate request
    if (!(req.body.group_name)) {
       return res.status(400).send({ "is_error": true, "message": "Amenities type name can't be empty." });
    }

    // Validate if Facility record exist in our database
    const oldRecord = await groupModel.findOne({  _id: { $ne: req.params.id } , 'slug': slugify((req.body.group_name).toLowerCase()) });

    if (oldRecord) {
    return res.status(409).send({"is_error": true , "message":  req.body.group_name + " Already Exist." });
    }


    // Find facility type and update it with the request body
    groupModel.findOneAndUpdate({ _id: req.params.id }, {
        group_name: req.body.group_name,
        slug: slugify((req.body.group_name).toLowerCase()),
        group_type: req.body.group_type ? req.body.group_type : 'STANDARD'
    }, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Amenities Type not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Amenities Type not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Amenities Type " + err
            });
        });
};

// Get all DB facility groups
exports.getAllGroups = async (req, res) => {
    // groupModel.updateMany({},{'group_type':'STANDARD'} , {new: true})
    // .then(async response => {
    //     console.log("Success")
    // })
    try {
        if (req.query.key && req.query.key != '' && req.query.orderBy) {
            const GroupData = await groupModel.find({ parent: { $eq: null } }).sort([[req.query.key, req.query.orderBy]]);
            return res.send({ is_error: false, data: GroupData });
        }
        else {
            const GroupData = await groupModel.find({ parent: { $eq: null } }).sort([["updatedAt",-1]]);
            return res.send({ is_error: false, data: GroupData });
        }
        
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Delete 
exports.delete = (req, res) => {
    groupModel.findByIdAndRemove(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Amenities Type not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Amenities Type deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Amenities Type not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Amenities Type with id " + req.params.id
        });
    });
};

// Change type status
exports.changeStatus = async (req, res) => {

    await groupModel.findByIdAndUpdate(req.params.hotelId, {
        is_active: req.body.is_active
    }, { new: true })
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({ 'message': 'Status has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the status."
            });
        });
};