var slugify = require('slugify')
const FAQcatModal = require('../model/faq_categories');
const helper = require('../middleware/_helper');

// Add Faq Category
exports.addgroup = async (req, res) => {
    // Validate request
    if (!(req.body.category_name)) {
        return res.status(400).send({ "is_error": true, "message": "Please provide FAQ Category name." });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // Validate if FaqCategory exist in our database
        const isDataExist = await FAQcatModal.findOne({ 'category_name': req.body.category_name});

        if (isDataExist) {
        return res.status(409).send({"is_error": true , "message":  req.body.category_name + "FAQ Category Already Exist." });
        }
        // Create a FaqCategory
        const FaqCategoryDataPayload = new FAQcatModal({
            category_name: req.body.category_name
        });

        // Save FaqCategory in the database
        FaqCategoryDataPayload.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
               return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while creating Category."
                });
            });
    }
};

exports.update = async (req, res) => {
    // Validate request
    if (!(req.body.category_name)) {
       return res.status(400).send({ "is_error": true, "message": "Category name can't be empty." });
    }

    // Validate if record exist in our database
    const oldRecord = await FAQcatModal.findOne({  _id: { $ne: req.params.id } , 'category_name': req.body.category_name });

    if (oldRecord) {
    return res.status(409).send({"is_error": true , "message": 'Category ' +  req.body.category_name + " Already Exist." });
    }


    // Find faq Category and update it with the request body
    FAQcatModal.findOneAndUpdate({ _id: req.params.id }, {
        category_name: req.body.category_name,
        is_active: true
    }, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Category not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Category not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Category " + err
            });
        });
};

// Get all DB FAQ Categories
exports.getAllFaqCategories = async (req, res) => {
    try {
        if (req.query.key && req.query.key != '' && req.query.orderBy) {
            const GroupData = await FAQcatModal.find({}).sort([[req.query.key,req.query.orderBy]]);
            return res.send({ is_error: false, data: GroupData });
        }
        else{
            const GroupData = await FAQcatModal.find({}).sort([["updatedAt",-1]]);
            return res.send({ is_error: false, data: GroupData });
        }
       
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Delete 
exports.delete = (req, res) => {
    FAQcatModal.findByIdAndRemove(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Category not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Category deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Category not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Category with id " + req.params.id
        });
    });
};

// Change type status
exports.changeStatus = async (req, res) => {

    await FAQcatModal.findByIdAndUpdate(req.params.hotelId, {
        is_active: req.body.is_active
    }, { new: true })
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({ 'message': 'Status has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the status."
            });
        });
};