var slugify = require('slugify')
const hotelModel = require('../model/hotel');
const roomModel = require('../model/rooms');
const companyModel = require('../model/company');

const mediaModel = require('../model/hotel_images');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");
const XLSX = require('xlsx');

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')


/// Create and Save a new Hotel
exports.create = (req, res) => {
    console.log("Hotel Body data", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Hotel Name." });
    }
    if (!req.body.company_id) {
        return res.status(400).send({ "is_error": true, "message": "Please select associated company." });
    }
    // Create a Hotel
    const hotelRecord = new hotelModel({
        name: req.body.name,
        about_us: req.body.about_us,
        email: req.body.email,
        phone: req.body.phone,
        address_line: req.body.address_line,
        address_line2: req.body.address_line2,
        contact_first_name: req.body.contact_first_name,
        contact_last_name: req.body.contact_last_name,
        latitude: req.body.latitude,
        longitude: req.body.longitude,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code,
        region: req.body.region,
        company_id: req.body.company_id,
        property_type: req.body.property_type,
        property_class: req.body.property_class,
        town: req.body.town,
        total_rooms: req.body.total_rooms,
        available_rooms: 0 ,
        slug: slugify((req.body.name).toLowerCase()),
        checkIn: req.body.checkIn,
        checkOut: req.body.checkOut,
        city_proximity: req.body.city_proximity,
        beach_proximity: req.body.beach_proximity ,
        proximity_unit: req.body.proximity_unit,
        countryMetaData: JSON.parse(req.body.countryMetaData),
        stateMetaData: JSON.parse(req.body.stateMetaData),
        cityMetaData: JSON.parse(req.body.cityMetaData),
        externalVideoList: req.body.externalVideoList ? JSON.parse(req.body.externalVideoList) : [],
        rating: req.body.rating ? req.body.rating : 0,
        minimum_age: req.body.minimum_age,
        no_of_pools: req.body.no_of_pools,
        no_of_restaurants: req.body.no_of_restaurants,
        property_brand: req.body.property_brand,
        no_of_bars: req.body.no_of_bars,
        hotelFacilities: req.body.hotelFacilities ? JSON.parse(req.body.hotelFacilities) : [],
        highlightedFacilities: req.body.highlightedFacilities ? JSON.parse(req.body.highlightedFacilities) : [],
        hotelLabels: req.body.hotelLabels ? JSON.parse(req.body.hotelLabels) : [],
        property_code: req.body.property_code,
        embed_google_map: req.body.embed_google_map,

    });

    // Save Hotel in the database
    hotelRecord.save()
        .then(async data => {
            let media = [];
            const mediaRootPath = "public/uploads/hotels/";
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const projectMediaFiles = req.files[key];
                    await projectMediaFiles.forEach(async mediaFile => {
                        media.push({
                            path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                            filename: mediaFile.filename,
                            ref_id: data._id,
                            type: mediaFile.fieldname,
                            mimetype: mediaFile.mimetype,
                            extn: (mediaFile.filename.split('.').pop()).toLowerCase()
                        });
                    })
    
                } else {
                    console.log("Else condition block")
                }
            })
            // store all images,documents and videos
            await mediaModel.insertMany(media);
    
            res.send({ is_error: false, data: data });
        }).catch(err => {
             // delete all uploaded project media files from directory
            const mediaRootPath = "public/uploads/hotels/";
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const projectMediaFiles = req.files[key];
                    await projectMediaFiles.forEach(async mediaFile => {
                        // call util method to remove file from location
                        mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                    })
                }
            })
            return res.status(500).send({
                is_error: true,
                message: err.message || "Some error occurred while creating the Hotel."
            });
        });
};

// Retrieve and return all hotels from the database.
exports.findAll = async (req, res) => {
    try {
        console.log("req.query", req.query)
        var query = (req.query && req.query.company_id) ? req.query : {}
        const page = await hotelModel.find(query)
        .populate({ path: 'company_id'})
        .populate({ path: 'town'})
        .populate({ path: 'property_type'})
        .populate({ path: 'mainPhoto'})
        .populate({ path: 'BannerPhoto'})
        .sort([["updatedAt", -1]]);
        res.send({ is_error: false, data: page });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a single Hotel Details with a id
exports.findOne = (req, res) => {
    hotelModel.findById(req.params.id)
        .then(async response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found with id " + req.params.id
                });
            }
            const projectMedia = await mediaModel.find({ref_id: req.params.id});
            console.log("projectMedia", projectMedia);
            response.mediaFiles = projectMedia ;
            res.send({is_error : false, data: response, mediaFiles: projectMedia });
            // res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving hotel details with id " + req.params.id
            });
        });
};

// Find a single hotel with a slug
exports.findHotelBySlug = (req, res) => {
    hotelModel.findOne({ 'slug': req.params.slug })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found for " + req.params.slug
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found for  " + req.params.slug
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Hotel details for  " + req.params.slug
            });
        });
};

// Find a single hotel details to show in Admin Section details page.
exports.getHotelDetailsForAdminPage = (req, res) => {
    hotelModel.findById(req.params.id)
    .populate({ path: 'company_id', select: ["company_name","company_logo"] })
    .populate({ path: 'property_type', select: ["property_type"] })
    .populate({ path: 'BannerPhoto'})
    .populate({ path: 'mainPhoto'})
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found for " + req.params.slug
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            console.log("error", err);
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found for  " + req.params.slug
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Hotel details for  " + req.params.slug
            });
        });
};

// Update Hotel details
exports.update = (req, res) => {

    console.log("req.body", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Hotel Name." });
    }
    if (!req.body.company_id) {
        return res.status(400).send({ "is_error": true, "message": "Please select associated company." });
    }
    // Create a Hotel
    const hotelRecord = {
        name: req.body.name,
        about_us: req.body.about_us,
        email: req.body.email,
        phone: req.body.phone,
        address_line: req.body.address_line,
        address_line2: req.body.address_line2,
        contact_first_name: req.body.contact_first_name,
        contact_last_name: req.body.contact_last_name,
        latitude: req.body.latitude,
        longitude: req.body.longitude,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code,
        region: req.body.region,
        company_id: req.body.company_id,
        property_type: req.body.property_type,
        property_class: req.body.property_class,
        town: req.body.town,
        total_rooms: req.body.total_rooms,
        available_rooms: 0 ,
        slug: slugify((req.body.name).toLowerCase()),
        checkIn: req.body.checkIn,
        checkOut: req.body.checkOut,
        city_proximity: req.body.city_proximity,
        beach_proximity: req.body.beach_proximity ,
        proximity_unit: req.body.proximity_unit,
        countryMetaData: JSON.parse(req.body.countryMetaData),
        stateMetaData: JSON.parse(req.body.stateMetaData),
        cityMetaData: JSON.parse(req.body.cityMetaData),
        externalVideoList: req.body.externalVideoList ? JSON.parse(req.body.externalVideoList) : [],
        rating: req.body.rating ? req.body.rating : 0,
        minimum_age: req.body.minimum_age,
        no_of_pools: req.body.no_of_pools,
        no_of_restaurants: req.body.no_of_restaurants,
        property_brand: req.body.property_brand,
        no_of_bars: req.body.no_of_bars,
        hotelFacilities: req.body.hotelFacilities ? JSON.parse(req.body.hotelFacilities) : [],
        highlightedFacilities:  req.body.highlightedFacilities ? JSON.parse(req.body.highlightedFacilities) : [],
        hotelLabels: req.body.hotelLabels ? JSON.parse(req.body.hotelLabels) : [],
        property_code: req.body.property_code,
        embed_google_map: req.body.embed_google_map,

    };

    // Find Hotel and update it with the request body
    hotelModel.findByIdAndUpdate(req.params.id, hotelRecord, { new: true })
        .then(async response => {
            console.log("response", response)
            let media = [];
            const mediaRootPath = "public/uploads/hotels/";
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const projectMediaFiles = req.files[key];
                    await projectMediaFiles.forEach(async mediaFile => {
                        media.push({
                            path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                            filename: mediaFile.filename,
                            ref_id: response._id,
                            type: mediaFile.fieldname,
                            mimetype: mediaFile.mimetype,
                            extn: (mediaFile.filename.split('.').pop()).toLowerCase()
                        });
                    })

                } else {
                    console.log("Else condition block")
                }
            })

            if(!response) {
                // remove all recently uploaded images from directory
                media.forEach(element => {
                    mediaUtils.unlink(element.path);
                });
                return res.status(404).send({
                    is_error : true,
                    message: "Hotel Details not found with id " + req.params.id
                });
            }
            // store all images,documents and videos
            await mediaModel.insertMany(media);
            // Remove all the removed media from directory and Media Collection
            if (req.body.existingFilesData) {
                const filesTobeRemoved = JSON.parse(req.body.existingFilesData);
                await filesTobeRemoved.forEach(element => {
                    if(element.deleted){
                        mediaUtils.unlink(element.path);
                        // delete record from Media collection
                        mediaModel.findByIdAndUpdate(element._id,element).exec();
                    }else{
                        // only update the records with updated data of description
                        mediaModel.findByIdAndUpdate(element._id,element).exec();
                    }
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            console.log("err", err)
            // delete all uploaded Hotel media files from directory
            const mediaRootPath = "public/uploads/hotels/";
            const mediaKey = Object.keys(req.files);
            mediaKey.forEach(async key => {
                if (req.files[key].length && req.files[key].length > 0) {
                    // multiple files
                    const projectMediaFiles = req.files[key];
                    await projectMediaFiles.forEach(async mediaFile => {
                        // call util method to remove file from location
                        mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                    })
                }
            })
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id + "Error Details: -- " + err
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Hotel with id " + err
            });
        });
};

// Delete a Hotel with the specified id in the request
exports.delete = (req, res) => {
    hotelModel.findByIdAndRemove(req.params.id)
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, message: "Hotel deleted successfully!" });
        }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Could not delete Hotel with id " + req.params.id
            });
        });
};

// Change project status
exports.changeStatus = async (req, res) => {
 // check the company status , If active then only allow Hotel to mark Active  when req.body data is coming true.
    if(req.body.is_active){
        const hotelDetails = await hotelModel.findById(req.params.hotelId);
        if(hotelDetails){
            const companyStatus = await companyModel.findOne({_id: hotelDetails.company_id});
            if(!companyStatus.is_active){
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel status cannot be marked as Opened , Parent Company Sale is STOPPED currently."
                });
            }
    
        }else{
            return res.status(404).send({
                is_error: true,
                message: "Invalid Hotel Details."
            }); 
        }
    }
    await hotelModel.findByIdAndUpdate(req.params.hotelId, { is_active: req.body.is_active }, { timestamps: false })
        .then(async responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Hotel Details."
                });
            }
            const roomsRecords_success = await roomModel.updateMany({hotel_id:req.params.hotelId },{'is_available':req.body.is_active}).exec();

            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({ 'message': 'Hotel has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the Hotel status."
            });
        });
};

// get all available Labels
exports.getAllLabels = async (req, res) => {
    try {
        const hotelsList = await hotelModel.find({});
        var Labels = [];
        await hotelsList.filter(item => {
           if(item.hotelLabels && item.hotelLabels.length != 0){
            Labels = [...Labels , ...item.hotelLabels]
           }
        })
        console.log("labels", Labels)
        res.send({ is_error: false, data: Labels });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

exports.getHotelImages = async (req, res) => {
    const hotelImagesdata = await mediaModel.find({ref_id: req.params.hotelId ,deleted: false });
    res.send({ is_error: false, data: hotelImagesdata });
};

exports.setHotelMainPhoto = async(req, res) => {
    const HotelMainPhoto = await mediaModel.findOne({ deleted: false , ref_id : req.params.id, type: 'hotel_images'}).exec();
    console.log("Found hotel photo", HotelMainPhoto);
    if(HotelMainPhoto && HotelMainPhoto != null){
      const querySucess = await hotelModel.updateOne({_id:req.params.id}, {$set:{mainPhoto: HotelMainPhoto._id, BannerPhoto: HotelMainPhoto._id}}, { timestamps: false }).exec();
    }
    res.send({ is_error: false, data:[], message: "Data Updated Successfully with Latest details."});

  }


exports.dumpHotelData = async (req,res) => {

    // console.log("selected file", fileName)
    var workbook = XLSX.readFile('./public/assets/mockData/hotels/Hotels.xlsx');
    var sheet_name_list = workbook.SheetNames;
    console.log("no. of sheets", sheet_name_list);
    // console.log(XLSX.utils.sheet_to_json(workbook.Sheets[sheet_name_list[0]]))
    const parsedData = XLSX.utils.sheet_to_json(workbook.Sheets[sheet_name_list[0]]) ;
    // var parsedData = [];
    //  sheet_name_list.forEach(function(y) {
    //     var worksheet = workbook.Sheets[y];
    //     var headers = {};
    //     var data = [];
    //     var headersArr = [];
    //     var payload = {
    //         project_id: null,
    //         keyword_name: '',
    //         rankData: []
    //     };
    //     var fullDBArrData = [];

    //     // console.log("worksheet",worksheet);
    //     for(z in worksheet) {
    //         if(z[0] === '!') continue;
    //         //parse out the column, row, and value
    //         var col = z.substring(0,1);
    //         var row = parseInt(z.substring(1));
    //         var value = worksheet[z].v;
    //         //store header names
    //         if(row == 1) {
    //             headers[col] = value;
    //             continue;
    //         }
    //         if(headers[col] === 'name'){
    //             headersArr.push(value);
    //             payload.name = value;
    //             headersArr.push('slug');
    //             payload.slug = slugify((payload.name).toLowerCase())
    //         }else{
    //             headersArr.push(value);
    //         }
    //         // if(headers[col] != 'Keywords'){
    //         //     headersArr.push(value);
    //         //     var dateValue = moment(headers[col], "YYYY-MM-DD", true)
    //         //     // console.log("dateValue",dateValue)
    //         //     // console.log("Is valid date",dateValue.isValid())
    //         //     rankDetailObj = {
    //         //         rankAt: headers[col],
    //         //         dayat: dateValue.date(),
    //         //         month: dateValue.month(),
    //         //         year: dateValue.year(),
    //         //         rank: value,
    //         //     }
    //         //     payload.rankData.push(rankDetailObj);
    //         // }
    //         if(!data[row]) data[row]={};
    //         data[row][headers[col]] = value;
    //         fullDBArrData.push(payload);
    //     }
    //     // console.log("headers array", headersArr)
    //     //drop those first two rows which are empty
    //     data.shift();
    //     data.shift();
    //     // console.log("fullDBArrData",JSON.stringify(fullDBArrData));
    //     // console.log("fullDBArrData",fullDBArrData);
    //     parsedData = data ;
    // });
    res.send(parsedData)

    parsedData.forEach(async item=>{
        // console.log("keyword", item.Keywords)
        const payload = {
            name: item.name,
            email: 'sandals@hotel.com',
            company_id: item.company_id,
            property_type: item.property_type,
            town: item.town,
            slug: slugify((item.name).toLowerCase()),
            region: 'caribbean',
            total_rooms: item.total_rooms,
            checkIn: '09:00',
            checkOut: '12:00',
            // phone: req.body.phone,
            // address_line: req.body.address_line,
            // address_line2: req.body.address_line2,
            // contact_first_name: req.body.contact_first_name,
            // contact_last_name: req.body.contact_last_name,
            // latitude: req.body.latitude,
            // longitude: req.body.longitude,
            // country: req.body.country,
            // state: req.body.state,
            // city: req.body.city,
            // zip_code: req.body.zip_code,
            // countryMetaData: JSON.parse(req.body.countryMetaData),
            // stateMetaData: JSON.parse(req.body.stateMetaData),
            // cityMetaData: JSON.parse(req.body.cityMetaData),
        };
        console.log("final Payload", payload)
        const hotelRecord = new hotelModel(payload);
        // Save record in the database
        await hotelRecord.save();
        // const existingRecord = await keywordModel.findOne({ 'keyword_name': payload.keyword_name ,'project_id': payload.project_id });
        // if(existingRecord){
        //     console.log("Need to update record for id", existingRecord._id)
        //     console.log("Data to add", payload.rankData)
        //     const updateSuccess = await keywordModel.updateOne(
        //         { _id: existingRecord._id },
        //         { $addToSet: { rankData: { $each: payload.rankData } } }
        //       )
        //     console.log("updateSuccess", updateSuccess)
        //     // res.send({'message':'need to update the record', data: existingRecord});
        // }else{
        //     console.log("create new recordd", payload)
        //     const payloadData = new keywordModel(payload);
        //     // Save record in the database
        //     await payloadData.save()
        // }
    })

    // res.send({})
};