var slugify = require('slugify')
const templateCategoryModel = require('../model/template_category');

// Create and Save a new Template Category
exports.create = (req, res) => {
    console.log("Category Body data", req.body)
    // Validate request
    if (!(req.body.name)) {
        return res.status(400).send({"is_error": true , "message": "Please provide template category name."});
      }

    // Create a Template Category
    const dataToSave = new templateCategoryModel({
        name: req.body.name , 
        slug: slugify((req.body.name).toLowerCase())
    });

    // Save Data in database
    dataToSave.save()
    .then(data => {
        res.send({is_error : false, data: data });
    }).catch(err => {
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while creating the Category."
        });
    });
};

// Retrieve and return all template Categories from the database.
exports.findAll = async (req, res) => {
    try {
        const returnData = await templateCategoryModel.find({}).sort([["updatedAt",-1]]);
        res.send({is_error : false, data: returnData});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single template Category with a id
exports.findOne = (req, res) => {
    templateCategoryModel.findById(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "No Category found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "No Category found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving category with id " + req.params.id
        });
    });
};

// Find a single template Category with a slug
exports.findCategoryBySlug = (req, res) => {
    templateCategoryModel.findOne({'slug':req.params.slug})
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "No Categoryfound for " + req.params.slug
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "No template Categoryfound for  " + req.params.slug
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving template Category details for  " + req.params.slug
        });
    });
};

// Update a template category identified by the id in the request
exports.update = (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // Validate Request
    if(!req.body.name) {
        return res.status(400).send({
            message: "Category name can not be empty."
        });
    }

    // Find category and update it with the request body
    templateCategoryModel.findByIdAndUpdate(req.params.id, {
        name: req.body.name , 
        slug: slugify((req.body.name).toLowerCase())
    }, {new: true})
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "No category found with id " + req.params.id
            });
        }
        res.send( { is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "No category found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error updating category with id " + err
        });
    });
};

// Delete a template category with the specified id in the request
exports.delete = (req, res) => {
    console.log('Category template delete', req.params.id)
    templateCategoryModel.findByIdAndRemove(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "No category found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Category deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "No Category found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete category with id " + req.params.id
        });
    });
};