var slugify = require('slugify')
const townModel = require('../model/towns');
const helper = require('../middleware/_helper');

// Add Property group
exports.add = async (req, res) => {
    // Validate request
    if (!(req.body.town_name)) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Town name." });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // check if Name already exist
        // Validate if Group exist in our database
        const isDataExist = await townModel.findOne({ 'slug': slugify((req.body.town_name).toLowerCase()),'created_by': loggedInUser.data.user_id, 'parent': null });

        if (isDataExist) {
        return res.status(409).send({"is_error": true , "message":  req.body.town_name + "Town Already Exist." });
        }
        // Create a Group
        const groupDataPayload = new townModel({
            town_name: req.body.town_name,
            created_by: loggedInUser.data.user_id,
            slug: slugify((req.body.town_name).toLowerCase()),
            country: req.body.country,
            countryMetaData: req.body.countryMetaData
        });

        // Save Group in the database
        groupDataPayload.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
               return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while creating the Property Type."
                });
            });
    }
};

exports.update = async (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // Validate request
    if (!(req.body.town_name)) {
       return res.status(400).send({ "is_error": true, "message": "Town name can't be empty." });
    }

    // Validate if Town record exist in our database
    const oldRecord = await townModel.findOne({  _id: { $ne: req.params.id } , 'slug': slugify((req.body.town_name).toLowerCase()) });
    console.log("old record", oldRecord)
    if (oldRecord) {
    return res.status(409).send({"is_error": true , "message":  req.body.town_name + " Already Exist." });
    }


    // Find Town and update it with the request body
    townModel.findOneAndUpdate({ _id: req.params.id }, {
        town_name: req.body.town_name,
        slug: slugify((req.body.town_name).toLowerCase()),
        country: req.body.country,
        countryMetaData: req.body.countryMetaData
    }, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Town not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Town not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Town " + err
            });
        });
};

// Get all DB Town groups
exports.getAll = async (req, res) => {
    try {
        const GroupData = await townModel.find({ parent: { $eq: null } }).sort([["updatedAt",-1]]);
        res.send({ is_error: false, data: GroupData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};


// Delete 
exports.delete = (req, res) => {
    townModel.findByIdAndRemove(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Town not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Town deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Town not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Town with id " + req.params.id
        });
    });
};

// Change type status
exports.changeStatus = async (req, res) => {

    await townModel.findByIdAndUpdate(req.params.id, {
        is_active: req.body.is_active
    }, { new: true })
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({ 'message': 'Status has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the status."
            });
        });
};


// Get all DB Town groups
exports.getTownByCountryName = async (req, res) => {
    try {
        const GroupData = await townModel.find({ parent: { $eq: null }, country:req.params.country }).sort([["updatedAt",-1]]);
        res.send({ is_error: false, data: GroupData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};