var slugify = require('slugify')
const faqModel = require('../../model/faq');
const FAQcatModal = require('../../model/faq_categories');

// Retrieve and return all FAQs from the database.
exports.findAll = async (req, res) => {
    try {
        const FAQ = await faqModel.find({is_active: true})
        .populate({path:'category_id'})
        .populate({path:'company_id'})
        .sort([["updatedAt",-1]]);
        res.send({is_error : false, data: FAQ});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single FAQ with a id
exports.findOne = (req, res) => {
    faqModel.findById(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving FAQ details with id " + req.params.id
        });
    });
};

// Find a single FAQ with a slug
exports.findFAQBySlug = (req, res) => {
    faqModel.findOne({'slug':req.params.slug})
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found for " + req.params.slug
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found for  " + req.params.slug
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving FAQ for  " + req.params.slug
        });
    });
};

// Get all DB FAQ Categories
exports.getAllFaqCategories = async (req, res) => {
    try {
        if (req.query.key && req.query.key != '' && req.query.orderBy) {
            const GroupData = await FAQcatModal.find({is_active: true}).sort([[req.query.key,req.query.orderBy]]);
            return res.send({ is_error: false, data: GroupData });
        }
        else{
            // const GroupData = await FAQcatModal.find({is_active: true}).sort([["category_name",1]]);
            // return res.send({ is_error: false, data: GroupData });
            const GroupData = await FAQcatModal.aggregate([
                { $match: {is_active: true} },
                {$sort: {"category_name": 1}},
                {
                    $lookup: {
                        from: 'faqs',
                        localField: '_id',
                        foreignField: 'category_id',
                        as: 'associated_faqs'
                    }
                }
            ]);
            return res.send({ is_error: false, data: GroupData });

        }
       
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};
