var slugify = require('slugify')
const hotelModel = require('../../model/hotel');
const groupModel = require('../../model/hotel_category');

const roomModel = require('../../model/rooms');
const companyModel = require('../../model/company');

const mediaModel = require('../../model/hotel_images');

const helper = require('../../middleware/_helper');
const mediaUtils = require("../../config/unlinkMedia");
const XLSX = require('xlsx');

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra');
const sharp = require("sharp");

async function getMetadata() {
    try {
      const metadata = await sharp("./public/uploads/hotels/hotel_images/hotel_images-1680801667465-JuItginGcRcGoH1BmfOMgi.jpg").metadata();
      console.log(metadata);
    } catch (error) {
      console.log(`An error occurred during processing: ${error}`);
    }
  }

// Retrieve and return all hotels from the database.
exports.findAll = async (req, res) => {
    // hotelModel.updateMany({}, {'is_active':true} , {new: true})
    // .then(async response => {
    //     console.log("Success")
    // })
    try {
        if (req.query.searchText && req.query.searchText != '') {
            const query = {
                $or: [
                    { 'name': { $regex: '.*' + req.query.searchText + '.*', $options: 'i' } },
                    // { 'about_us': { $regex: '.*' + req.query.searchText + '.*', $options: 'i' } },
                    { 'property_code': { $regex: '.*' + req.query.searchText + '.*', $options: 'i' } },
                    { 'property_class': { $regex: '.*' + req.query.searchText + '.*', $options: 'i' } },
                    { 'property_brand': { $regex: '.*' + req.query.searchText + '.*', $options: 'i' } },
                    { 'city': { $regex: '.*' + req.query.searchText + '.*', $options: 'i' } },
                    { 'state': { $regex: '.*' + req.query.searchText + '.*', $options: 'i' } },
                    { 'country': { $regex: '.*' + req.query.searchText + '.*', $options: 'i' } },
                    { 'region': { $regex: '.*' + req.query.searchText + '.*', $options: 'i' } }
                ], 
                'price_starts_form': {$ne:0},
                'selling_price_starts_form': {$ne:0},
                'is_active': true,
                'is_stop_sale': false,

            };

            // const hotels = await hotelModel.find({$text: {$search: req.query.searchText}})
            const hotels = await hotelModel.find(query)
            .populate({ path: 'town'})
            .populate({ path: 'property_type'})
            .populate({ path: 'mainPhoto'})
            .populate({ path: 'BannerPhoto'})
            .populate({ path: 'highlightedFacilities'})
            .sort([["selling_price_starts_form", req.query.sortByPrice ? req.query.sortByPrice : 'asc']]);
            res.send({ is_error: false, data: hotels });

        }else{
            console.log("else block")
            const hotels = await hotelModel.find({
                'price_starts_form': {$ne:0},
                'selling_price_starts_form': {$ne:0},
                'is_active': true,
                'is_stop_sale': false,
            })
            .populate({ path: 'town'})
            .populate({ path: 'property_type'})
            .populate({ path: 'mainPhoto'})
            .populate({ path: 'BannerPhoto'})
            .populate({ path: 'highlightedFacilities'})
            .sort([["selling_price_starts_form",  req.query.sortByPrice ? req.query.sortByPrice : 'asc']]);
            res.send({ is_error: false, data: hotels });

        }
       console.log("req.query hotels", req.query)

       

        // const query = {
        //     $or: [{ 'tags': { $in: lowercasedTags } },
        //     { 'persontags': { $in: lowercasedTags } }], 'created_by': loggedInUser.data.user_id
        // }
        // const hotels = await hotelModel.aggregate([
        //     { $match: { 'country': { $in: req.query.destinations } } },
        //     {
        //     $lookup: {
        //         from: 'hotels_images',
        //         localField: '_id',
        //         foreignField: 'ref_id',
        //         pipeline:[{"$match":{"deleted":false, type:"hotel_images"}}],
        //         as: 'media'
        //     }
        // }]);
        
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a single Hotel Details with a id
exports.findOne = async (req, res) => {
    console.log("find one", req.query)

    // hotelModel.findById(req.params.id)
    //     .then(async response => {
    //         if (!response) {
    //             return res.status(404).send({
    //                 is_error: true,
    //                 message: "Hotel details not found with id " + req.params.id
    //             });
    //         }
    //         const projectMedia = await mediaModel.find({ref_id: req.params.id});
    //         console.log("projectMedia", projectMedia);
    //         response.mediaFiles = projectMedia ;
    //         res.send({is_error : false, data: response, mediaFiles: projectMedia });
    //         // res.send({ is_error: false, data: response });
    //     }).catch(err => {
    //         if (err.kind === 'ObjectId') {
    //             return res.status(404).send({
    //                 is_error: true,
    //                 message: "Hotel details not found with id " + req.params.id
    //             });
    //         }
    //         return res.status(500).send({
    //             is_error: true,
    //             message: "Error retrieving hotel details with id " + req.params.id
    //         });
    //     });
    const hotelDetails = await hotelModel.aggregate([
        { $match: {  '_id': req.params.id } },
        {
        $lookup: {
            from: 'hotels_images',
            localField: '_id',
            foreignField: 'ref_id',
            // pipeline:[{"$match":{"deleted":false}}],
            as: 'media'
        }
    }]);
    res.send({ is_error: false, data: hotelDetails });
};

// Find a single hotel with a slug
exports.findHotelBySlug = async (req, res) => {
    console.log("called by slug details", req.params.slug)
    // hotelModel.findOne({ 'slug': req.params.slug })
    //     .then(response => {
    //         if (!response) {
    //             return res.status(404).send({
    //                 is_error: true,
    //                 message: "Hotel details not found for " + req.params.slug
    //             });
    //         }
    //         res.send({ is_error: false, data: response });
    //     }).catch(err => {
    //         if (err.kind === 'ObjectId') {
    //             return res.status(404).send({
    //                 is_error: true,
    //                 message: "Hotel details not found for  " + req.params.slug
    //             });
    //         }
    //         return res.status(500).send({
    //             is_error: true,
    //             message: "Error retrieving Hotel details for  " + req.params.slug
    //         });
    //     });
    const hotelDetails = await hotelModel.aggregate([
        { $match: {  'slug': req.params.slug } },
        {
            $lookup: {
                from: 'hotels_images',
                localField: '_id',
                foreignField: 'ref_id',
                // pipeline:[{"$match":{"deleted":false}}],
                as: 'media'
            }
    },
    {
        $lookup: {
            from: 'facilities',
            localField: 'hotelFacilities',
            foreignField: '_id',
            as: 'facilities'
        }
    }
]);

console.log("found hotel Details", hotelDetails)
    
//    const finalDetails = await hotelModel.populate(hotelDetails, {
//         path:'hotelFacilities'
//     });
    res.send({ is_error: false, data: hotelDetails });

};

// Get all DB Property Type groups
exports.getAllPropertyTypes = async (req, res) => {
    try {
        console.log("proptype called")
        // const GroupData = await groupModel.find({ parent: { $eq: null } , is_active: true }).sort([["property_type",1]]);
        const propertyTypesData = await groupModel.aggregate([
            { $match: { parent: { $eq: null } , is_active: true } },
            {
                $lookup: {
                    from: 'hotels',
                    localField: '_id',
                    foreignField: 'property_type',
                    as: 'hotelsData'
                }
            },
            {"$addFields":{
                "hotel_counts":{$size: "$hotelsData"},
                "hotelsData": "$$REMOVE"
            }},
            {
                $group : { 
                    _id : "$_id", 
                   data: { $push: "$$ROOT" } 
                }
            },
            {
                $sort:{_id:1}
            }
    ]);
        res.send({ is_error: false, data: propertyTypesData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Get all DB Property Class groups
exports.getAllPropertyClass = async (req, res) => {
    try {
        console.log("Prop Class called")
        // const GroupData = await groupModel.find({ parent: { $eq: null } , is_active: true }).sort([["property_type",1]]);
        const propertyClassData = await hotelModel.aggregate([
            { $match: { 'is_active': true, 'is_stop_sale': false } },
            {
                $group : { 
                    _id : "$property_class", 
                    // "hotel_counts":{$count: {}}
                    "hotel_counts":{$sum:1}

                }
            },
            {
                $sort:{_id:1}
            }
    ]);
        res.send({ is_error: false, data: propertyClassData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Get all DB Property Brand groups
exports.getAllPropertyBrands = async (req, res) => {
    try {
        console.log("Prop Brand called")
        const propertyBrandData = await hotelModel.aggregate([
            { $match: { 'is_active': true, 'is_stop_sale': false } },
            {
                $group : { 
                    _id : "$property_brand", 
                    // "hotel_counts":{$count: {}}
                    "hotel_counts":{$sum: 1}
                }
            },
            {
                $sort:{_id:1}
            }
    ]);
        res.send({ is_error: false, data: propertyBrandData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Get all DB Property Destinations groups
exports.getAllPropertyDestinations = async (req, res) => {
    try {
        console.log("Prop Brand called")
        const propertyDestinationData = await hotelModel.aggregate([
            { $match: { 'is_active': true, 'is_stop_sale': false } },
            {
                $group : { 
                    _id : "$country", 
                    // "hotel_counts":{$count: {}}
                    "hotel_counts":{$sum: 1}
                }
            },
            {
                $sort:{_id:1}
            }
    ]);
        res.send({ is_error: false, data: propertyDestinationData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};


exports.searchHotels = async (req, res) => {
    try {
        console.log("req.body search payload", req.body)
        var _condition = [];

        if(req.body.country && req.body.country.length > 0){
            const q = { 'country': { $in: req.body.country } }
            _condition.push(q);
        }
        if(req.body.rating && req.body.rating.length > 0){
            const q = { 'rating': { $in: req.body.rating } }
            _condition.push(q);
        }
        if(req.body.brands && req.body.brands.length > 0){
            const q = { 'property_brand': { $in: req.body.brands } }
            _condition.push(q);
        }
        if(req.body.propertyType && req.body.propertyType.length > 0){
            const q = { 'property_type': { $in: req.body.propertyType } }
            _condition.push(q);
        }
        if(req.body.propertyClass && req.body.propertyClass.length > 0){
            const q = { 'property_class': { $in: req.body.propertyClass } }
            _condition.push(q);
        }
        if(req.body.amenities && req.body.amenities.length > 0){
            const q = { 'hotelFacilities': { $all: req.body.amenities } }
            _condition.push(q);
        }
        // if(req.body.searchText && req.body.searchText != ''){
        //     const q = { 'country': { $in: req.body.country } }
        //     finalQuery.push(q);
        // }
        console.log("final COndition", _condition)
        if (_condition && _condition.length >0) {
            const query = {
                price_starts_form: {$ne:0},
                selling_price_starts_form: {$ne:0},
                is_active: true,
                is_stop_sale: false,
                $and: _condition , 
            };

            // const hotels = await hotelModel.find({$text: {$search: req.query.searchText}})
            const hotels = await hotelModel.find(query)
            .populate({ path: 'town'})
            .populate({ path: 'property_type'})
            .populate({ path: 'mainPhoto'})
            .populate({ path: 'BannerPhoto'})
            .populate({ path: 'highlightedFacilities'})
            .sort([["selling_price_starts_form", req.query.sortByPrice ? req.query.sortByPrice : 'asc']]);
            res.send({ is_error: false, data: hotels });

        }else{
            console.log("else block")
            const hotels = await hotelModel.find({'price_starts_form': {$ne:0},
            'selling_price_starts_form': {$ne:0},
            'is_active': true,
            'is_stop_sale': false})
            .populate({ path: 'town'})
            .populate({ path: 'property_type'})
            .populate({ path: 'mainPhoto'})
            .populate({ path: 'BannerPhoto'})
            .populate({ path: 'highlightedFacilities'})
            .sort([["selling_price_starts_form",  req.query.sortByPrice ? req.query.sortByPrice : 'asc']]);
            res.send({ is_error: false, data: hotels });

        }
       console.log("req.query hotels", req.query)

       

        // const query = {
        //     $or: [{ 'tags': { $in: lowercasedTags } },
        //     { 'persontags': { $in: lowercasedTags } }], 'created_by': loggedInUser.data.user_id
        // }
        // const hotels = await hotelModel.aggregate([
        //     { $match: { 'country': { $in: req.query.destinations } } },
        //     {
        //     $lookup: {
        //         from: 'hotels_images',
        //         localField: '_id',
        //         foreignField: 'ref_id',
        //         pipeline:[{"$match":{"deleted":false, type:"hotel_images"}}],
        //         as: 'media'
        //     }
        // }]);
        
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};