const User = require("../model/user");
const OTPModel = require("../model/otp");
const TempUserModel = require("../model/temp_user");
const deviceTokenModel = require("../model/deviceTokens");
const helper = require('../middleware/_helper');
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
const jwksClient = require('jwks-rsa');
const auth = require("../middleware/auth");
const request = require('request');
const otpGenerator = require('otp-generator');
var moment = require('moment'); // require
const emailCtrl = require('../controllers/email.controller');

const email_templates = require('../config/email_template_ids');

const passport = require('passport');
const GoogleStrategy = require('passport-google-oauth20').Strategy;
const FacebookStrategy = require('passport-facebook').Strategy;

const express = require("express");
const app = express();

app.use(passport.initialize());

passport.serializeUser(function (user, done) {
  done(null, user);
});

passport.deserializeUser(function (user, done) {
  done(null, user);
});

passport.use(
  new GoogleStrategy(
    {
      clientID: process.env.GOOGLE_CLIENT_ID,
      clientSecret: process.env.GOOGLE_CLIENT_SECRET,
      callbackURL: process.env.GOOGLE_APP_CALLBACK_URL,
    },
    async function (accessToken, refreshToken, profile, cb) {
      // const [user, status] = await User.findOrCreate({
      //   where: {
      //     social_user_id: profile.id,
      //     name: profile.displayName,
      //     registration_type: "google",
      //   },
      // });
      console.log("profile data from google", profile);
      cb(null, profile);
    }
  )
);
const { getGoogleLogin, handleGoogleLogin } = require("../routes/auth_google_route");
app.get("/google", getGoogleLogin);
app.get("/google/callback", handleGoogleLogin);

// https://developers.facebook.com/apps/236459691932060/fb-login/settings/#
// App Secret- 341fd3e0265d6debf91e9cfce9a951e1
// Facebook code
passport.use(new FacebookStrategy({
  clientID: process.env.FB_CLIENT_ID,
  clientSecret: process.env.FB_CLIENT_SECRET,
  callbackURL: "http://localhost:3000/auth/facebook/callback"
},
  function (accessToken, refreshToken, profile, done) {
    console.log("FB profile data ------", profile);
    return done(null, profile);
  }
));
app.get('/facebook',
  passport.authenticate('facebook'));

app.get('/facebook/callback',
  passport.authenticate('facebook', { failureRedirect: '/login' }),
  function (req, res) {
    // Successful authentication, redirect home.
    res.redirect('/');
  });

// GET graph.facebook.com/debug_token?
// input_token={token-to-inspect}
// &access_token={app-token-or-admin-token}

// Register
app.post("/register", async (req, res) => {
  console.log("body Payload", req.body);
  // Our register logic starts here
  try {
    // Get user input
    const { first_name, last_name, email, password } = req.body;

    // Validate user input
    if (!(email && password && first_name && last_name)) {
      res.status(400).send({ "is_error": true, "message": "All input is required" });
    }

    // check if user already exist
    // Validate if user exist in our database
    const oldUser = await User.findOne({ email: email.toLowerCase()});

    if (oldUser) {
      return res.status(409).send({ "is_error": true, "message": "User Already Exist. Please Login" });
    }
    //Encrypt user password
    encryptedPassword = await bcrypt.hash(password, 10);

    //  check if data is available in Temp user collection then update the temp user data with new verification code
    // else create entry in temp user collection.
    const OTP = otpGenerator.generate(6, { digits: true, lowerCaseAlphabets: false, upperCaseAlphabets: false, specialChars: false });

    const userPayload = {
      first_name: first_name,
      last_name: last_name,
      email: email.toLowerCase(), // sanitize: convert email to lowercase
      password: encryptedPassword,
      verificationCode: OTP
    };


    TempUserModel.findOneAndUpdate({ email: email.toLowerCase() }, userPayload, {
      new: true,
      upsert: true // Make this update into an upsert
    }, function (err, tempUserData) {
      if (err) return res.status(500).send({ "is_error": true, "message": "Error while registration. Please try after some time.", "error": err });
      // User data stored in Temp table send email to user for verify account.
      const textMsg = 'Dear' + first_name + ' ' + last_name + ', Your OTP verification code is ' + OTP + ' Thanks , CTN Vacations';
      const htmlTextMsg = '<h6> Dear ' + first_name + ' ' + last_name + ',</h6><p> Your OTP verification code is </br> <strong>' + OTP + '</strong></p> </br> Thanks, </br> CTN Vacations.'
      const emailData = {
        msg: {
          to: userPayload.email,
          from: 'book@ctn.vacations', // Use the email address or domain you verified above
          subject: 'CTN- Verify your Email',
          text: textMsg,
          html: htmlTextMsg
        },
        userDetails: tempUserData
      };
      // const emailData = {
      //   msg: {
      //     to: userPayload.email,
      //     from: 'book@ctn.vacations', // Use the email address or domain you verified above
      //     template_id: email_templates.ACCOUNT_VERIFICATION_OTP_TEMPLATE_ID,
      //     dynamic_template_data: {
      //       "first_name": first_name,
      //       "last_name": last_name,
      //       "OTP": OTP
      //     }
      //   },
      //   userDetails: tempUserData
      // };
      // send Email to User with OTP
      emailCtrl.sendEmail(emailData);
      return res.send({ is_error: false, data: {}, message: "OTP has been sent to email . Please verify the OTP." });
      // return res.send('Succesfully saved.');
    });
  } catch (err) {
    console.log(err);
  }
  // Our register logic ends here
});

// Verify Email
app.post("/verify-email", async (req, res) => {
  console.log("body Payload", req.body);
  // Our logic starts here
  try {
    // Get user input
    const { otp, email } = req.body;

    // Validate user input
    if (!(otp && email)) {
      res.status(400).send({ "is_error": true, "message": "Please provide OTP." });
    } else {

      // Validate if otp exist in our database
      const user = await TempUserModel.findOne({ 'email': email.toLowerCase(), 'verificationCode': req.body.otp });
      console.log("temp User found", user)
      if (user) {
        // delete temp user entry from DB

        TempUserModel.findByIdAndDelete(user._id, function (err, data) {
          if (err) {
            return res.status(404).send({
              is_error: true,
              message: "Invalid OTP.Either you have entered wrong OTP or your OTP has been expired."
            });
          }
          else {
            // Create user in our database
            const newUser = new User({
              "first_name": data.first_name,
              "last_name": data.last_name,
              "email": (data.email).toLowerCase(),
              "password": data.password,
            });

            // Save user in the database
            newUser.save()
              .then(data => {
                // Create token
                const token = jwt.sign(
                  { user_id: data._id, email: (data.email).toLowerCase() },
                  process.env.TOKEN_KEY,
                  {
                    expiresIn: "2h",
                  }
                );
                // save user token
                data.token = token;

                // return new user
                res.status(201).send(data);

              }).catch(err => {
                res.status(500).send({
                  is_error: true,
                  message: err.message || "Some error occurred while creating the user."
                });
              });
          }
        });

      } else {
        res.status(400).send({ "is_error": true, "message": "Invalid OTP.Either you have entered wrong OTP or your OTP has been expired" });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our logic ends here
});

// Login
app.post("/login", async (req, res) => {
  // Our login logic starts here
  try {
    // Get user input
    const { email, password } = req.body;
    // Validate user input
    if (!(email && password)) {
      res.status(400).send({ "is_error": true, "message": "All input is required" });
    } else {
      // Validate if user exist in our database
      const user = await User.findOne({ email: email.toLowerCase() });
      if (user && (await bcrypt.compare(password, user.password))) {
        if (!user.is_active) {
          return res.status(409).send({ "is_error": true, "message": "Your Account is Inactive. Please contact Administrator." });
        }
        // Create token
        const token = jwt.sign(
          { user_id: user._id, email , role: user.role},
          process.env.TOKEN_KEY,
          {
            expiresIn: "2h",
          }
        );
        // save user token to DB
        // const updatedUserData = await User.findByIdAndUpdate(user.id, { token: token }, { new: true });
        // response send to UI
        const responseSendToUI = {
          "_id": user._id,
          "first_name": user.first_name,
          "last_name": user.last_name,
          "email": user.email,
          "is_admin": user.is_admin,
          "is_active": user.is_active,
          "profileImage": user.profileImage,
          "token": token,
          "wishList": user.wishList ? user.wishList : []
        }
        user.token = token;
        // Saving Device Token to DB for FCM notifications
        const deviceToken = req.headers["rgd-token"];
        const deviceType = req.headers["device_type"];

        if (deviceToken) {
          const deviceTokenData = new deviceTokenModel({
            registrationToken: deviceToken,
            user_id: user._id,
            deviceType: deviceType
          });
          // Save device token in the database
          deviceTokenData.save()
            .then(data => {
              return res.status(200).json(responseSendToUI);
            }).catch(err => {
              return res.status(200).json(responseSendToUI);
            });
        } else {
          return res.status(200).json(responseSendToUI);
        }

      } else {
        return res.status(400).send({ "is_error": true, "message": "Invalid Credentials." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our Login logic ends here
});

app.post("/user/login", async (req, res) => {
  // Our login logic starts here
  try {
    // Get user input
    const { email, password } = req.body;
    // Validate user input
    if (!(email && password)) {
      res.status(400).send({ "is_error": true, "message": "All input is required" });
    } else {
      // Validate if user exist in our database
      const user = await User.findOne({ email: email.toLowerCase() });
      if (user && (await bcrypt.compare(password, user.password))) {
        if (!user.is_active) {
          return res.status(409).send({ "is_error": true, "message": "Your Account is Inactive. Please contact Administrator." });
        }
        if (user.role != 'APP_USER') {
          return res.status(409).send({ "is_error": true, "message": "Invalid Credentials. Please check your login details" });
        }
        // Create token
        const token = jwt.sign(
          { user_id: user._id, email , role: user.role},
          process.env.TOKEN_KEY,
          {
            // expiresIn: "24h",
          }
        );
        // save user token to DB
        // const updatedUserData = await User.findByIdAndUpdate(user.id, { token: token }, { new: true });
        // response send to UI
        const responseSendToUI = {
          "_id": user._id,
          "first_name": user.first_name,
          "last_name": user.last_name,
          "email": user.email,
          "gender": user.gender,
          "is_admin": user.is_admin,
          "is_active": user.is_active,
          "profileImage": user.profileImage,
          "token": token,
          "wishList": user.wishList ? user.wishList : []

        }
        user.token = token;
        // Saving Device Token to DB for FCM notifications
        const deviceToken = req.headers["rgd-token"];
        const deviceType = req.headers["device_type"];

        if (deviceToken) {
          const deviceTokenData = new deviceTokenModel({
            registrationToken: deviceToken,
            user_id: user._id,
            deviceType: deviceType
          });
          // Save device token in the database
          deviceTokenData.save()
            .then(data => {
              return res.status(200).json(responseSendToUI);
            }).catch(err => {
              return res.status(200).json(responseSendToUI);
            });
        } else {
          return res.status(200).json(responseSendToUI);
        }

      } else {
        return res.status(400).send({ "is_error": true, "message": "Invalid Credentials." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our Login logic ends here
});

app.get('/logout', auth, async (req, res) => {
  const token = req.body.token || req.query.token || req.headers["x-access-token"];
  const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
  User.updateOne({ "token": token }, { $unset: { token: 1 } })
    .then(async data => {

      // Delete device token from collection on logout
      const deviceToken = req.headers["rgd-token"];
      console.log("logged out user Data", deviceToken)
      deviceTokenModel.deleteMany({ registrationToken: deviceToken })
        .then(devicetokenresponse => {
          console.log('SUccess device tolken delete', devicetokenresponse);
          res.send({ "is_error": false, "message": "Logged out successfully." });

        }).catch(err => {
          return res.status(200).json(responseSendToUI);
        });

    }).catch(err => {
      res.status(500).send({
        message: err.message || "Some error occurred while Logout."
      });
    });
});

// Forgot Password
app.post("/forgot-password", async (req, res) => {
  console.log("body Payload", req.body);
  // Our logic starts here
  try {
    // Get user input
    const { email } = req.body;

    // Validate user input
    if (!(email)) {
      res.status(400).send({ "is_error": true, "message": "Please provide user email." });
    } else {
      // Validate if user exist in our database
      const user = await User.findOne({ email: email.toLowerCase() ,role:'APP_USER' });

      if (user) {
        const user = await User.findOne({ email , role:'APP_USER'});

        const OTP = otpGenerator.generate(6, { digits: true, lowerCaseAlphabets: false, upperCaseAlphabets: false, specialChars: false });
        const expireTime = moment(new Date(), "DD-MM-YYYY hh:mm:ss")
          .add(1, 'minutes')
          .format('DD/MM/YYYY hh:mm:ss');

        // const textMsg = 'Dear' + user.first_name + ' ' + user.last_name + ', Your OTP verification code is ' + OTP + ' Thanks , Team LifeStampR Support.';
        // const htmlTextMsg = '<h6> Dear ' + user.first_name + ' ' + user.last_name + ',</h6><p> Your OTP verification code is </br> <strong>' + OTP + '</strong></p> </br> Thanks, </br> Team LifeStampR Support.'
        const emailData = {
          msg: {
            to: user.email,
            from: 'book@ctn.vacations', // Use the email address or domain you verified above
            template_id: email_templates.FORGOT_PASSWORD_OTP_TEMPLATE_ID,
            dynamic_template_data: {
              "first_name": user.first_name,
              "last_name": user.last_name,
              "OTP": OTP
            }
          },
          userDetails: user
        }
        const OTP_Payload = {
          user_id: user._id,
          email: user.email,
          otpvalue: OTP
        };
        let OTP_data = await OTPModel.findOneAndUpdate({ email: user.email, user_id: user._id }, OTP_Payload, {
          new: true,
          upsert: true // Make this update into an upsert
        });
        if (OTP_data) {
          // send Email to User with OTP
          emailCtrl.sendEmail(emailData);
          res.send({ is_error: false, data: {}, message: "OTP has been sent to email . Please verify the OTP." });

        } else {
          res.status(400).send({ "is_error": true, "message": "Error while registration. Please try after some time." });
        }
      } else {
        res.status(400).send({ "is_error": true, "message": "Invalid Details" });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our logic ends here
});

// validate OTP
app.post("/validate-otp", async (req, res) => {
  console.log("body Payload", req.body);
  // Our logic starts here
  try {
    // Get user input
    const { otp } = req.body;

    // Validate user input
    if (!(otp)) {
      res.status(400).send({ "is_error": true, "message": "Please provide OTP." });
    } else {

      // Validate if otp exist in our database
      const user = await OTPModel.findOne({ 'otpvalue': req.body.otp });

      if (user) {

        // Find note and update it with the request body
        OTPModel.findByIdAndUpdate(user._id, { otp_verfied: true })
          .then(otpData => {
            if (!otpData) {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            res.send({
              is_error: false,
              message: "OTP has been verified successfully."
            });
          }).catch(err => {
            if (err.kind === 'ObjectId') {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            return res.status(500).send({
              is_error: true,
              message: "Invalid OTP! Either you have entered wrong OTP or your OTP has been expired."
            });
          });

      } else {
        res.status(400).send({ "is_error": true, "message": "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our logic ends here
});

// change Password
app.post("/change-password", async (req, res) => {
  // Our logic starts here
  try {
    // Get user input
    const { password, email, otp } = req.body;

    // Validate user input
    if (!(password && email)) {
      res.status(400).send({ "is_error": true, "message": "Please provide passowrd" });
    } else {

      // Validate if user exist in our database
      const user = await User.findOne({ 'email': email.toLowerCase() });
      // Validate if otp exist in our database
      const OTPfound = await OTPModel.findOne({ 'email': email.toLowerCase(), 'otpvalue': req.body.otp });

      if (user && OTPfound && OTPfound.otp_verfied) {
        //Encrypt user password
        encryptedPassword = await bcrypt.hash(password, 10);

        // delete otp entry from DB
        OTPModel.findByIdAndRemove(OTPfound._id)
          .then(otpData => {
            if (!otpData) {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            // Find user and update password
            User.findByIdAndUpdate(user._id, {
              password: encryptedPassword,
            })
              .then(userData => {
                if (!userData) {
                  return res.status(404).send({
                    is_error: true,
                    message: "Error while updating password."
                  });
                }
                res.send({
                  is_error: false,
                  message: "Password has been changed successfully."
                });
              }).catch(err => {
                if (err.kind === 'ObjectId') {
                  return res.status(404).send({
                    is_error: true,
                    message: "Error while updating Password."
                  });
                }
                return res.status(500).send({
                  is_error: true,
                  message: "Error while updating Password."
                });
              });
          }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            return res.status(500).send({
              is_error: true,
              message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
            });
          });

      } else {
        res.status(400).send({ "is_error": true, "message": "Error while updating Password.Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our logic ends here
});

// Social profile Registration
app.post("/social/sign-on", async (req, res) => {
  console.log("google body Payload", req.query);
  // Our register logic starts here
  try {

    if (req.query && req.query.type === 'google') {
      // Validate user input
      if (!(req.body.email)) {
        return res.status(400).send({ "is_error": true, "message": "Email is mandatory." });
      }
      // Validate user input
      if (!(req.body.googleId && req.body.accountName)) {
        return res.status(400).send({ "is_error": true, "message": "Google Id and account name are mandatory." });
      }

      // check if user already exist
      // Validate if user exist in our database
      const oldUser = await User.findOne({ email: (req.body.email).toLowerCase(), googleProvider: { $exists: false } });

      console.log(oldUser);
      // if (oldUser) {
      //   return res.status(409).send({ "is_error": true, "message": "User Already Exist. Please Login" });
      // }

      const { accountName, googleId, email, profieImage } = req.body;
      //Encrypt user password
      encryptedPassword = await bcrypt.hash(googleId, 10);

      //  check if data is available in user collection then update the user data.
      // else create entry in user collection.

      const userPayload = {
        first_name: accountName,
        last_name: "",
        email: email.toLowerCase(), // sanitize: convert email to lowercase
        password: encryptedPassword,
        googleProvider: {
          id: googleId
        }
      };
      // Create user in our database
      User.findOneAndUpdate({ 'googleProvider.id': googleId }, userPayload, {
        new: true,
        upsert: true // Make this update into an upsert
      })
        .then(async response => {
          if (!response) {
            return res.status(404).send({
              is_error: true,
              message: "Error ! Please check the credentials & try again."
            });
          }
          // Create token
          const token = jwt.sign(
            { user_id: response._id, email: response.email },
            process.env.TOKEN_KEY,
            {
              // expiresIn: "2h",
            }
          );
          // save user token
          response.token = token;
          // response send to UI
          const responseSendToUI = {
            "_id": response._id,
            "first_name": response.first_name,
            "last_name": response.last_name,
            "email": response.email,
            "is_admin": response.is_admin,
            "is_active": response.is_active,
            "profileImage": response.profileImage,
            "token": token

          }
          // Saving Device Token to DB for FCM notifications
          const deviceToken = req.headers["rgd-token"];
          const deviceType = req.headers["device_type"];

          if (deviceToken) {
            const deviceTokenData = new deviceTokenModel({
              registrationToken: deviceToken,
              user_id: response._id,
              deviceType: deviceType
            });
            // Save device token in the database
            await deviceTokenData.save();
          }
          res.send({ is_error: false, data: responseSendToUI });
        }).catch(err => {
          if (err.kind === 'ObjectId') {
            return res.status(404).send({
              is_error: true,
              message: "Invalid Credentials."
            });
          }
          return res.status(500).send({
            is_error: true,
            message: "Error while processing your request. Pleae try after some time." + err
          });
        });
    }
    else if (req.query && req.query.type === 'facebook') {
      // Validate user input
      if (!(req.body.email)) {
        return res.status(400).send({ "is_error": true, "message": "Email is mandatory." });
      }
      // Validate user input
      if (!(req.body.facebookId && req.body.secretToken)) {
        return res.status(400).send({ "is_error": true, "message": "Facebook Id and Secrect are mandatory." });
      }

      const { first_name, last_name, email, profieImage, facebookId, secretToken } = req.body;

      // check if user already exist
      // Validate if user exist in our database
      const oldUser = await User.findOne({ email: (req.body.email).toLowerCase(), facebookProvider: { $exists: false } });

      console.log(oldUser);
      // if (oldUser) {
      //   return res.status(409).send({ "is_error": true, "message": "User Already Exist. Please Login" });
      // }
      //Encrypt user password
      encryptedPassword = await bcrypt.hash(facebookId, 10);

      request('https://graph.facebook.com/debug_token?input_token=' + secretToken + '&access_token=' + process.env.FB_CLIENT_ID + '|' + process.env.FB_CLIENT_SECRET, { json: true }, (err, response, body) => {
        if (err) { return console.log(err); }
        console.log(body);

        if (body.data.is_valid && body.data.user_id && body.data.user_id === facebookId) {
          //  check if data is available in user collection then update the user data.
          // else create entry in user collection.

          const userPayload = {
            first_name: first_name,
            last_name: last_name,
            email: email.toLowerCase(), // sanitize: convert email to lowercase
            password: encryptedPassword,
            facebookProvider: {
              id: facebookId
            }
          };
          // Create user in our database
          User.findOneAndUpdate({ 'facebookProvider.id': facebookId }, userPayload, {
            new: true,
            upsert: true // Make this update into an upsert
          })
            .then(async response => {
              if (!response) {
                return res.status(404).send({
                  is_error: true,
                  message: "Error ! Please check the credentials & try again."
                });
              }
              // Create token
              const token = jwt.sign(
                { user_id: response._id, email: response.email },
                process.env.TOKEN_KEY,
                {
                  // expiresIn: "2h",
                }
              );
              // save user token
              response.token = token;
              // Saving Device Token to DB for FCM notifications
              const deviceToken = req.headers["rgd-token"];
              const deviceType = req.headers["device_type"];

              if (deviceToken) {
                const deviceTokenData = new deviceTokenModel({
                  registrationToken: deviceToken,
                  user_id: response._id,
                  deviceType: deviceType
                });
                // Save device token in the database
                await deviceTokenData.save();
              }
              res.send({ is_error: false, data: response });
            }).catch(err => {
              if (err.kind === 'ObjectId') {
                return res.status(404).send({
                  is_error: true,
                  message: "Invalid Credentials."
                });
              }
              return res.status(500).send({
                is_error: true,
                message: "Error while processing your request. Pleae try after some time." + err
              });
            });
        } else {
          res.status(404).send({
            is_error: true,
            message: "Invalid credentials.Please check your access token or profile id not matched with provided Token."
          });
        }

      });
    }
    else if (req.query && req.query.type === 'apple') {
      const encryptedPassword = await bcrypt.hash(req.body.user, 10);

      const decodedToken = jwt.decode(req.body.identityToken, { complete: true });
      // const kid = decodedToken.header.kid ;
      // const publicKey = (await getApplePublickey(kid)).getPublicKey()
      // const publicKey = (await getApplePublickey(kid));
      const kid = "RkI5MjI5OUY5ODc1N0Q4QzM0OUYzNkVGMTJDOUEzQkFCOTU3NjE2Rg";
      const client = jwksClient({
        // jwksUri: "https://appleid.apple.com/auth/keys"
        jwksUri: 'https://sandrino.auth0.com/.well-known/jwks.json'
      });
      //  const signinKey = await client.getSigningKey(kid);
      //  console.log("signinKey",signinKey)
      client.getSigningKey(kid, async function (err, key) {
        if (err) {
          console.log("inside method", err); // This returns "JwksError: Forbidden"
        }
        console.log("key", key);
        if (key) {
          var signingKey = key.getPublicKey();
          console.log("signingKey", signingKey);
          if (signingKey) {
            const verifiedPayload = jwt.verify(req.body.identityToken, publicKey);
            // now validate req body data with verifed payload
            if (verifiedPayload.sub === req.body.user) {
              // means user is valid id
              if (req.body.email) {
                const userPayload = {
                  first_name: req.body.givenName,
                  last_name: req.body.familyName,
                  email: req.body.email.toLowerCase(), // sanitize: convert email to lowercase
                  password: encryptedPassword,
                  appleProvider: {
                    id: req.body.user
                  }
                };
                // Means user is New then check for old / existing user validation.
                User.findOneAndUpdate({ 'appleProvider.id': req.body.user }, userPayload, {
                  new: true,
                  upsert: true // Make this update into an upsert
                })
                  .then(async response => {
                    if (!response) {
                      return res.status(404).send({
                        is_error: true,
                        message: "Error ! Please check the credentials & try again."
                      });
                    }
                    // Create token
                    const token = jwt.sign(
                      { user_id: response._id, email: response.email },
                      process.env.TOKEN_KEY,
                      {
                        // expiresIn: "2h",
                      }
                    );
                    // save user token
                    response.token = token;
                    // response send to UI
                    const responseSendToUI = {
                      "_id": response._id,
                      "first_name": response.first_name,
                      "last_name": response.last_name,
                      "email": response.email,
                      "is_admin": response.is_admin,
                      "is_active": response.is_active,
                      "profileImage": response.profileImage,
                      "token": token

                    }
                    // Saving Device Token to DB for FCM notifications
                    const deviceToken = req.headers["rgd-token"];
                    const deviceType = req.headers["device_type"];

                    if (deviceToken) {
                      const deviceTokenData = new deviceTokenModel({
                        registrationToken: deviceToken,
                        user_id: response._id,
                        deviceType: deviceType
                      });
                      // Save device token in the database
                      await deviceTokenData.save();
                    }
                    res.send({ is_error: false, data: responseSendToUI });
                  }).catch(err => {
                    if (err.kind === 'ObjectId') {
                      return res.status(404).send({
                        is_error: true,
                        message: "Invalid Credentials."
                      });
                    }
                    return res.status(500).send({
                      is_error: true,
                      message: "Error while processing your request. Pleae try after some time." + err
                    });
                  });
              } else {
                // already registred user
                const userdetails = await User.findOne({ appleProvider: (req.body.user) });

                if (userdetails) {
                  // Create token
                  const token = jwt.sign(
                    { user_id: response._id, email: response.email },
                    process.env.TOKEN_KEY,
                    {
                      // expiresIn: "2h",
                    }
                  )
                  // Saving Device Token to DB for FCM notifications
                  const deviceToken = req.headers["rgd-token"];
                  const deviceType = req.headers["device_type"];

                  if (deviceToken) {
                    const deviceTokenData = new deviceTokenModel({
                      registrationToken: deviceToken,
                      user_id: response._id,
                      deviceType: deviceType
                    });
                    // Save device token in the database
                    await deviceTokenData.save();
                  }
                  userdetails.token = token;
                  res.send({ is_error: false, data: userdetails });
                }
              }
            } else {
              return res.status(400).send({ "is_error": true, "message": "Error: Not a valid user details." });
            }
          } else {
            return res.status(400).send({ "is_error": true, "message": "Error: Please check the token provided." });
          }
        } else {
          return res.status(400).send({ "is_error": true, "message": "Unable to verify your details.Please check the token provided." });
        }

      });
    }
    else {
      // throw error query parameter missing or not valid
      return res.status(400).send({ "is_error": true, "message": "Error: Either query parameter is missing or not valid." });
    }
  } catch (err) {
    console.log(err);
  }
  // Our register logic ends here
});

// Admin forgot password- step-1
app.post("/verify_admin_email", async (req, res) => {
  console.log("body Payload", req.body);
  // Our admin reset password logic starts here
  try {
    // Get user input
    // Validate user input
    if (!(req.body.email)) {
      res.status(400).send({ "is_error": true, "message": "Please provide Email." });
    } else {
      // Validate if user exist in our database
      const user = await User.findOne({ email: req.body.email.toLowerCase(), is_admin: true });
      console.log("Found User Data", user);

      if (user) {
        const user = await User.findOne({ email: req.body.email.toLowerCase(), is_admin: true });

        const OTP = otpGenerator.generate(6, { digits: true, lowerCaseAlphabets: false, upperCaseAlphabets: false, specialChars: false });

        const textMsg = 'Dear' + user.first_name + ' ' + user.last_name + ', Your OTP verification code is ' + OTP + ' Thanks , Team LifeStampR Support.';
        const htmlTextMsg = '<h6> Dear ' + user.first_name + ' ' + user.last_name + ',</h6><p> Your OTP verification code is </br> <strong>' + OTP + '</strong></p> </br> Thanks, </br> Team LifeStampR Support.'
        const emailData = {
          msg: {
            to: [user.email],
            from: 'book@ctn.vacations', // Use the email address or domain you verified above
            template_id: email_templates.FORGOT_PASSWORD_OTP_TEMPLATE_ID,
            dynamic_template_data: {
              "first_name": user.first_name,
              "last_name": user.last_name,
              "OTP": OTP
            }
          },
          userDetails: user
        }

        const OTP_Payload = {
          user_id: user._id,
          email: user.email,
          otpvalue: OTP
        };
        let OTP_data = await OTPModel.findOneAndUpdate({ email: user.email, user_id: user._id }, OTP_Payload, {
          new: true,
          upsert: true // Make this update into an upsert
        });
        if (OTP_data) {
          // send Email to Admin user with OTP
          emailCtrl.sendEmail(emailData);
          res.send({ is_error: false, data: {}, message: "OTP has been sent to email . Please verify the OTP." });

        } else {
          res.status(400).send({ "is_error": true, "message": "Error while validating details. Please try after some time." });
        }

      } else {
        return res.status(400).send({ "is_error": true, "message": "Invalid Credentials." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our admin reset password logic ends here
});

// Admin change Password
app.post("/change_admin_password", async (req, res) => {
  // Our logic starts here
  try {
    // Get user input
    const { password, email, otp } = req.body;

    // Validate user input
    if (!(password && email && otp)) {
      res.status(400).send({ "is_error": true, "message": "Please provide passowrd & OTP" });
    } else {

      // Validate if user exist in our database
      const user = await User.findOne({ 'email': email.toLowerCase(), is_admin: true });
      // Validate if otp exist in our database
      const OTPfound = await OTPModel.findOne({ 'email': email.toLowerCase(), 'otpvalue': req.body.otp });

      if (user && OTPfound) {
        //Encrypt user password
        encryptedPassword = await bcrypt.hash(password, 10);

        // delete otp entry from DB
        OTPModel.findByIdAndRemove(OTPfound._id)
          .then(otpData => {
            if (!otpData) {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            // Find user and update password
            User.findByIdAndUpdate(user._id, {
              password: encryptedPassword,
            })
              .then(userData => {
                if (!userData) {
                  return res.status(404).send({
                    is_error: true,
                    message: "Error while updating password."
                  });
                }
                res.send({
                  is_error: false,
                  message: "Password changed successfully."
                });
              }).catch(err => {
                if (err.kind === 'ObjectId') {
                  return res.status(404).send({
                    is_error: true,
                    message: "Error while updating Password."
                  });
                }
                return res.status(500).send({
                  is_error: true,
                  message: "Error while updating Password."
                });
              });
          }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
              return res.status(404).send({
                is_error: true,
                message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
              });
            }
            return res.status(500).send({
              is_error: true,
              message: "Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired."
            });
          });

      } else {
        res.status(400).send({ "is_error": true, "message": "Error while updating Password.Invalid OTP ! Either you have entered wrong OTP or your OTP has been expired." });
      }
    }
  } catch (err) {
    console.log(err);
  }
  // Our logic ends here
});

async function getApplePublickey(kid) {
  kid = "RkI5MjI5OUY5ODc1N0Q4QzM0OUYzNkVGMTJDOUEzQkFCOTU3NjE2Rg";
  const client = jwksClient({
    jwksUri: "https://appleid.apple.com/auth/keys"
    // jwksUri: 'https://sandrino.auth0.com/.well-known/jwks.json'
  });
  //  const signinKey = await client.getSigningKey(kid);
  //  console.log("signinKey",signinKey)
  client.getSigningKey(kid, function (err, key) {
    if (err) {
      console.log("inside method", err); // This returns "JwksError: Forbidden"
    }
    var signingKey = key.publicKey || key.rsaPublicKey;
    callback(null, signingKey);
    console.log("key", key)
    return key;

  });
  // return signinKey;
}


module.exports = app;