const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const categoryCtrl = require('../controllers/category.controller');

    // Retrieve all categories
    app.get("/", auth, categoryCtrl.getAllCategories);
    // Retrieve all categories
    app.get("/all_sub_category", auth, categoryCtrl.getAllSubCategories);
    // Retrieve my categories
    app.get("/myCategories", auth, categoryCtrl.getMyCategories);
    // Add a new category
    app.post('/add-category', auth, categoryCtrl.addCategory);
    // Add a sub category
    app.post('/add-sub-category', auth, categoryCtrl.addSubCategory);

    // Get all subcategoriesby category id
    app.get('/subcategory/:cat_id', auth, categoryCtrl.getMySubCategoriesByCatId);

    // // Retrieve a single page with id
    // app.get('/:slug', auth, pageCtrl.findPageBySlug);

    // // Retrieve a single page with id
    // app.get('/details/:id', auth, pageCtrl.findOne);

    // Update a Category & subcategory with id
    app.put('/update/:id', auth, categoryCtrl.update);

    // Delete a category with id
    app.delete('/delete/:cat_id', auth, categoryCtrl.delete);
    // Delete a subcategory with id
     app.delete('/delete/:cat_id/:subcat_id', auth, categoryCtrl.deleteSubcategory);

module.exports = app;