const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const facilityCtrl = require('../controllers/facilities.controller');

    // Retrieve all Ameneties
    app.get("/", auth, facilityCtrl.getAllAmenities);

    // app.get("/groupbyType", facilityCtrl.getAllAmenitiesbyGroup);
    app.get("/RoomAmenities", facilityCtrl.getRoomAmenities);
    app.get("/PropertyAmenities", facilityCtrl.getHotelsAmenities);
    app.get("/AllAmenities", facilityCtrl.getAllAmenitiesbyGroup);

    // routes for Left side filters
    app.get("/RoomAmenitiesFilters", facilityCtrl.getRoomAmenitiesFilters);
    app.get("/PropertyAmenitiesFilters", facilityCtrl.getHotelsAmenitiesFilters);
    app.get("/AllAmenitiesFilters", facilityCtrl.getAllAmenitiesbyGroupFilters);



   
    // Add a new Amenities
    app.post('/add', auth, facilityCtrl.addAmenities);

    // Update a Amenities with id
    app.put('/update/:id', auth, facilityCtrl.update);

    // Delete a facility with id
    app.delete('/delete/:id', auth, facilityCtrl.delete);

    // change status
    app.put('/change-status/:id', auth, facilityCtrl.changeStatus);
    // mockdata dump
    app.get("/dumpData/facilities", facilityCtrl.dumpFacilities);


module.exports = app;