const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const facilityGroupCtrl = require('../controllers/facility_group.controller');

    // Retrieve all facilities types
    app.get("/", auth, facilityGroupCtrl.getAllGroups);
   
    // Add a new facility type
    app.post('/add', auth, facilityGroupCtrl.addgroup);

    // Update a Amenities Type with id
    app.put('/update/:id', auth, facilityGroupCtrl.update);

    // Delete a facility type with id
    app.delete('/delete/:id', auth, facilityGroupCtrl.delete);

module.exports = app;