const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const faqCtrl = require('../controllers/faq.controller');
const faqCategoryCtrl = require('../controllers/faq_categories.controller');

    // Retrieve all FAQs
    app.get("/",  faqCtrl.findAll);
    // Create a new FAQ
    app.post('/add', auth, faqCtrl.create);

    // Retrieve a single FAQ with id
    app.get('/:slug',  faqCtrl.findFAQBySlug);

    // Retrieve a single FAQ with id
    app.get('/details/:id',  faqCtrl.findOne);

    // Update a FAQ with id
    app.put('/update/:id', auth, faqCtrl.update);

    // Delete a FAQ with id
    app.delete('/delete/:id', auth, faqCtrl.delete);

    // FAQ categories Routes

    // Retrieve all FAQs Categories
    app.get("/categories/all",  faqCategoryCtrl.getAllFaqCategories);

    // Add a new facility type
    app.post('/categories/add', auth, faqCategoryCtrl.addgroup);

    // Update a Amenities Type with id
    app.put('/categories/update/:id', auth, faqCategoryCtrl.update);

    // Delete a facility type with id
    app.delete('/categories/delete/:id', auth, faqCategoryCtrl.delete);

module.exports = app;