const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const hotelCtrl = require('../controllers/hotel.controller');

var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

    // Retrieve all Hotels
    app.get("/", auth, hotelCtrl.findAll);

    // Create a new Hotel
    app.post('/add', upload.fields([{ name: "company_logo" }]), auth, hotelCtrl.create);

    // Retrieve a single page with id
    app.get('/:slug',  hotelCtrl.findHotelBySlug);

    // Retrieve a single Hotel with hotelId
    app.get('/details/:id', auth, hotelCtrl.findOne);

    // Update a Hotels with hotelId
    app.put('/update/:id', upload.fields([{ name: "company_logo" }]),auth, hotelCtrl.update);

    // Delete a Hotels with hotelId
    app.delete('/delete/:id', auth, hotelCtrl.delete);

    
    // change Hotel status
    // app.put('/changeStatus/:hotelId', auth, hotelCtrl.changeStatus);

    // app.get("/assigned_hotels", auth, hotelCtrl.getUserAssignedHotels);

module.exports = app;