const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const hotelTypeCtrl = require('../controllers/hotel_category.controller');

    // Retrieve all room  types
    app.get("/", auth, hotelTypeCtrl.getAllPropertyTypes);
   
    // Add a new room type
    app.post('/add', auth, hotelTypeCtrl.addPropertyTypes);

    // Update a room Type with id
    app.put('/update/:id', auth, hotelTypeCtrl.update);

    // Delete a room type with id
    app.delete('/delete/:id', auth, hotelTypeCtrl.delete);

    // change status
    app.put('/change-status/:id', auth, hotelTypeCtrl.changeStatus);

module.exports = app;