const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const hotelCtrl = require('../controllers/hotel.controller');
var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

    // Retrieve all Hotels
    app.get("/", hotelCtrl.findAll);

    // Create a new Hotel
    app.post('/add', upload.fields([{ name: "hotel_images" }, { name: "hotel_videos" },{ name: "hotel_map" },{ name: "fact_sheet" }]), auth, hotelCtrl.create);

    // Retrieve a single page with id
    app.get('/:slug',  hotelCtrl.findHotelBySlug);

    // Retrieve a single Hotel with hotelId
    app.get('/details/:id', auth, hotelCtrl.findOne);

     // Retrieve a single Hotel with hotelId for admin Section detail page
     app.get('/hoteldetails/:id', auth, hotelCtrl.getHotelDetailsForAdminPage);

    // Update a Hotels with hotelId
    app.put('/update/:id', upload.fields([{ name: "hotel_images" }, { name: "hotel_videos" },{ name: "hotel_map" },{ name: "fact_sheet" }]), auth, hotelCtrl.update);

    // Delete a Hotels with hotelId
    app.delete('/delete/:id', auth, hotelCtrl.delete);

    // Retrieve all Hotels
    app.get("/labels/getAll", hotelCtrl.getAllLabels);
    
    // change Hotel status
    app.put('/changeStatus/:hotelId', auth, hotelCtrl.changeStatus);

    // Hotel Media Files
    // Retrieve a all images and photos of a Hotel
    app.get('/mediaFiles/:hotelId',  hotelCtrl.getHotelImages);

    // app.get("/assigned_hotels", auth, hotelCtrl.getUserAssignedHotels);

     // Set Hotel Current Applicable Main & Banner Photo
     app.put('/sync/:id', auth, hotelCtrl.setHotelMainPhoto);

    app.get("/dumpData/mock", hotelCtrl.dumpHotelData);


module.exports = app;