const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const notificationCtrl = require('../controllers/notification.controller');
    
// Retrieve all my notifications
app.get("/", auth, notificationCtrl.getMyNotifications);
// Retrieve all my unread notifications
app.get("/unread", auth, notificationCtrl.getMyUnreadNotifications);
// change notification status ( mark as read )
app.put('/markAsRead', auth , notificationCtrl.markNotificationAsRead);
// Create a new Notification
app.post('/add', notificationCtrl.create);
// Delete a notification  with id
 app.delete('/delete/:id', auth, notificationCtrl.delete);
 app.post('/delete', auth, notificationCtrl.deleteMultiple);


module.exports = app;