const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const bookingCtrl = require('../controllers/booking.controller');

    // Retrieve all Booking Transactions
    app.get("/",  auth, bookingCtrl.findAll);
    // Retrieve Last 10 bookings
    app.get("/latest",  auth, bookingCtrl.findBookingsForAdminDashboard);

    // Retrieve a single Booking details with id
    app.get('/details/:id', auth, bookingCtrl.findOne);

module.exports = app;