const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const roomCtrl = require('../controllers/room.controller');

var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

    // Retrieve all Rooms
    app.get("/", auth, roomCtrl.findAll);

    // Create a new Rooms
    app.post('/add', upload.fields([{ name: "room_photos" }, { name: "room_videos" }]), auth, roomCtrl.create);

    // Retrieve a single room with id
    app.get('/:slug',  roomCtrl.findRoomBySlug);

    // Retrieve a single room with roomId for Edit room page
    app.get('/details/:id', auth, roomCtrl.findOne);

    // Retrieve a single room with roomId for admin view details page
    app.get('/roomdetails/:id', auth, roomCtrl.findRoomAdminDetailsPageData);

    // Update a Room with roomId
    app.put('/update/:id', upload.fields([{ name: "room_photos" }, { name: "room_videos" }]),auth, roomCtrl.update);

    // Delete a Room with roomId
    app.delete('/delete/:id', auth, roomCtrl.delete);

    // change Room status
    app.put('/changeStatus/:id', auth, roomCtrl.changeStatus);

    // Retrieve Master PriceList of a room by hotel ID
    app.get("/masterPriceList/:id", auth, roomCtrl.getMasterRoomPriceList);

    // Room Media Files
    // Retrieve a all images and photos of a room
    app.get('/mediaFiles/:roomId',  roomCtrl.getRoomImages);

     // Set Room Current Applicable price and Main & Banner Photo
     app.put('/sync/:id', auth, roomCtrl.setRoomCurrentPriceandPhoto);

    app.get("/dumpData/mock", roomCtrl.dumpRoomData);
    app.get("/dumpData/roomprice", roomCtrl.dumpRoomPrices);

module.exports = app;