const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const townCtrl = require('../controllers/town.controller');

    // Retrieve all towns List
    app.get("/", auth, townCtrl.getAll);
   
    // Add a new town
    app.post('/add', auth, townCtrl.add);

    // Update a town with id
    app.put('/update/:id', auth, townCtrl.update);

    // Delete a town with id
    app.delete('/delete/:id', auth, townCtrl.delete);

    // change status
    app.put('/change-status/:id', auth, townCtrl.changeStatus);

    // Retrieve all towns by country name
    app.get("/filterbycountry/:country", auth, townCtrl.getTownByCountryName);

module.exports = app;