const auth = require("../../middleware/user_auth");
const express = require("express");
const app = express();
const bookingCtrl = require('../../controllers/v1.0/booking.controller');
const paymentCtrl = require('../../controllers/v1.0/payment.controller');

// Get My bookings
app.get('/', auth , bookingCtrl.mybookings);

// Retrieve a single room details with id
app.get('/details/:bookingId',  paymentCtrl.getBookingTransactionDetails);

// Get My Transactions Payments
app.get('/mytransactions', auth , bookingCtrl.myTransactions);

module.exports = app;