const auth = require("../../middleware/auth");
const express = require("express");
const app = express();
const roomCtrl = require('../../controllers/v1.0/rooms.controller');
const paymentCtrl = require('../../controllers/v1.0/payment.controller');

    // Retrieve all rooms
    app.get("/", roomCtrl.findAll);
    // Retrieve all rooms
    app.get("/room_levels", roomCtrl.getRoomLevels);
    
    // Retrieve a all images and photos of a room
    app.get('/mediaFiles/:roomId',  roomCtrl.getRoomImages);

    // Retrieve a single room details with id
    app.get('/details/:slug',  roomCtrl.findRoomBySlug);

    // Retrieve a single room details with  current effective selling price 
    app.get('/bookingPriceDetails/:roomId',  roomCtrl.getBookingRoomPriceData);

    app.post('/make-payment', paymentCtrl.makePayments);

    app.post('/getRoomRates', roomCtrl.getCurrentRoomRates);


    // // Retrieve a single Hotel with hotelId
    // app.get('/details/:id', auth, hotelCtrl.findOne);

module.exports = app;