// const auth = require("../middleware/auth");
const auth = require("../../middleware/user_auth");
const express = require("express");
const app = express();
const userCtrl = require('../../controllers/user.controller');

var multer = require("multer");
const { storage } = require("../../config/multer.config");
var upload = multer({ storage: storage });


// User Section API routes
    // Retrieve my account details of logged in Web user
    app.get('/my-details', auth, userCtrl.myDetails);
   
    // Update logged in user profile details
    app.put('/my-profile/update', auth, userCtrl.updateMyAccount);
    // send contact us form
    app.post('/contact-us', auth, userCtrl.submitContactUsForm);
    // change Passowrd - My profile
    app.post('/changePassword', auth, userCtrl.changeMyPassword);
    // validate OTP - My profile
    app.post('/validate-otp', auth, userCtrl.validateOtp);
    // update Password- My profile
    app.post('/update-password', auth, userCtrl.updatePassword);
    app.post('/change-avatar', auth, userCtrl.changeProfilePic);
    
    // Delete a User with userId
    app.delete('/delete', auth, userCtrl.deleteMyAccount);

     // Retrieve my property wishlist of logged in Web user
     app.get('/my-wishlist', auth, userCtrl.myWishList);

    // Add Property to user's wishlist- Loggedin user
    app.post('/addToWishlist', auth, userCtrl.addToWishlist);
    // Remove Property to user's wishlist- Loggedin user
    app.post('/removeFromWishlist', auth, userCtrl.removeFromWishlist);

    // change Passowrd - Admin user
    app.post('/admin/change-password', auth, userCtrl.changeAdminPassword);

module.exports = app;